/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction.projectile_behavior;

import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ItemProjectilePlacementContext
extends BlockPlaceContext {
    ItemProjectileEntity itemProjectileEntity;

    public ItemProjectilePlacementContext(Level world, ItemProjectileEntity itemProjectileEntity, BlockHitResult blockHitResult) {
        super(world, null, InteractionHand.MAIN_HAND, itemProjectileEntity.getItem(), blockHitResult);
        this.itemProjectileEntity = itemProjectileEntity;
    }

    public Direction getNearestLookingDirection() {
        return Direction.getFacingAxis((Entity)this.itemProjectileEntity, (Direction.Axis)Direction.Axis.Y);
    }

    public Direction getNearestLookingVerticalDirection() {
        return this.itemProjectileEntity.getViewXRot(1.0f) < 0.0f ? Direction.UP : Direction.DOWN;
    }

    public Direction[] getNearestLookingDirections() {
        Direction[] directions = Direction.orderedByNearest((Entity)this.itemProjectileEntity);
        if (!this.replaceClicked) {
            int i;
            Direction direction = this.getClickedFace();
            for (i = 0; i < directions.length && directions[i] != direction.getOpposite(); ++i) {
            }
            if (i > 0) {
                System.arraycopy(directions, 0, directions, 1, i);
                directions[0] = direction.getOpposite();
            }
        }
        return directions;
    }
}

