/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy.storage;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelRegistries;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class IndividualCappedInkStorage
implements InkStorage {
    protected final long maxEnergyPerColor;
    protected final Map<InkColor, Long> storedEnergy = new Object2LongArrayMap();
    protected long currentTotal;

    public IndividualCappedInkStorage(long maxEnergyPerColor) {
        this(maxEnergyPerColor, (Iterable<InkColor>)PastelRegistries.INK_COLOR);
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Iterable<InkColor> supportedColors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.currentTotal = 0L;
        for (InkColor color : supportedColors) {
            this.storedEnergy.put(color, 0L);
        }
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Map<InkColor, Long> colors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.storedEnergy.putAll(colors);
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            this.storedEnergy.put(color.getKey(), color.getValue());
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedEnergy.containsKey(color);
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long resultingAmount = this.storedEnergy.get(color) + amount;
        if (resultingAmount > this.maxEnergyPerColor) {
            long overflow = resultingAmount - this.maxEnergyPerColor;
            this.currentTotal = this.maxEnergyPerColor;
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            return overflow;
        }
        this.currentTotal += amount;
        this.storedEnergy.put(color, resultingAmount);
        return 0L;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.getOrDefault(color, 0L);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyPerColor * (long)this.storedEnergy.size();
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyPerColor;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.getMaxTotal();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.ink_storage.stores_ink_per_type", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyPerColor)}));
        for (InkColor color : PastelRegistries.INK_COLOR) {
            long amount = this.storedEnergy.getOrDefault(color, 0L);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyPerColor - this.storedEnergy.get(color);
    }

    @Override
    public void fillCompletely() {
        this.currentTotal = 0L;
        for (InkColor color : this.storedEnergy.keySet()) {
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            this.currentTotal += this.maxEnergyPerColor;
        }
    }

    @Override
    public void clearContent() {
        this.storedEnergy.clear();
    }

    public Set<InkColor> getSupportedColors() {
        return this.storedEnergy.keySet();
    }
}

