/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy.color;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColorTags;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class InkColors {
    public static final ResourceLocation BASE_ADVANCEMENT_ID = PastelCommon.locate("midgame/pastel_midgame");
    public static final ResourceLocation BLACK_ADVANCEMENT_ID = PastelCommon.locate("midgame/pastel_midgame");
    public static final ResourceLocation WHITE_ADVANCEMENT_ID = PastelCommon.locate("lategame/collect_moonstone");
    private static final DeferredRegister<InkColor> REGISTER = DeferredRegister.create(PastelRegistryKeys.INK_COLOR, (String)"pastel");
    public static final int BLACK_TEXT_COLOR = -13620911;
    public static final int CYAN_COLOR = -10747923;
    public static final int MAGENTA_COLOR = -45066;
    public static final int YELLOW_COLOR = -1184512;
    public static final int BLACK_COLOR = -16645882;
    public static final int WHITE_COLOR = -1;
    public static final int ORANGE_COLOR = -427219;
    public static final int LIME_COLOR = -6750409;
    public static final int PINK_COLOR = -24634;
    public static final int RED_COLOR = -972236;
    public static final int LIGHT_BLUE_COLOR = -8741121;
    public static final int GREEN_COLOR = -11375857;
    public static final int BLUE_COLOR = -14404865;
    public static final int PURPLE_COLOR = -8377404;
    public static final int BROWN_COLOR = -9420787;
    public static final int LIGHT_GRAY_COLOR = -5395027;
    public static final int GRAY_COLOR = -12171706;
    public static final InkColor CYAN = InkColors.register("cyan", new InkColor(DyeColor.CYAN, -10747923, BASE_ADVANCEMENT_ID));
    public static final InkColor LIGHT_BLUE = InkColors.register("light_blue", new InkColor(DyeColor.LIGHT_BLUE, -8741121, BASE_ADVANCEMENT_ID));
    public static final InkColor BLUE = InkColors.register("blue", new InkColor(DyeColor.BLUE, -14404865, BASE_ADVANCEMENT_ID));
    public static final InkColor PURPLE = InkColors.register("purple", new InkColor(DyeColor.PURPLE, -8377404, BASE_ADVANCEMENT_ID));
    public static final InkColor MAGENTA = InkColors.register("magenta", new InkColor(DyeColor.MAGENTA, -45066, BASE_ADVANCEMENT_ID));
    public static final InkColor PINK = InkColors.register("pink", new InkColor(DyeColor.PINK, -24634, BASE_ADVANCEMENT_ID));
    public static final InkColor RED = InkColors.register("red", new InkColor(DyeColor.RED, -972236, BASE_ADVANCEMENT_ID));
    public static final InkColor ORANGE = InkColors.register("orange", new InkColor(DyeColor.ORANGE, -427219, BASE_ADVANCEMENT_ID));
    public static final InkColor YELLOW = InkColors.register("yellow", new InkColor(DyeColor.YELLOW, -1184512, BASE_ADVANCEMENT_ID));
    public static final InkColor LIME = InkColors.register("lime", new InkColor(DyeColor.LIME, -6750409, BASE_ADVANCEMENT_ID));
    public static final InkColor GREEN = InkColors.register("green", new InkColor(DyeColor.GREEN, -11375857, BASE_ADVANCEMENT_ID));
    public static final InkColor BROWN = InkColors.register("brown", new InkColor(DyeColor.BROWN, -9420787, BLACK_ADVANCEMENT_ID));
    public static final InkColor BLACK = InkColors.register("black", new InkColor(DyeColor.BLACK, -16645882, -13620911, BLACK_ADVANCEMENT_ID));
    public static final InkColor GRAY = InkColors.register("gray", new InkColor(DyeColor.GRAY, -12171706, WHITE_ADVANCEMENT_ID));
    public static final InkColor LIGHT_GRAY = InkColors.register("light_gray", new InkColor(DyeColor.LIGHT_GRAY, -5395027, WHITE_ADVANCEMENT_ID));
    public static final InkColor WHITE = InkColors.register("white", new InkColor(DyeColor.WHITE, -1, WHITE_ADVANCEMENT_ID));
    public static final List<InkColor> BUILTIN_COLORS = List.of(CYAN, LIGHT_BLUE, BLUE, PURPLE, MAGENTA, PINK, RED, ORANGE, YELLOW, LIME, GREEN, BROWN, BLACK, GRAY, LIGHT_GRAY, WHITE);

    protected static InkColor register(String name, InkColor inkColor) {
        REGISTER.register(name, () -> inkColor);
        return inkColor;
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }

    public static Iterable<InkColor> all() {
        return PastelRegistries.INK_COLOR;
    }

    public static List<InkColor> elementals() {
        return PastelRegistries.INK_COLOR.getTag(InkColorTags.ELEMENTAL_COLORS).map(entries -> entries.stream().map(Holder::value).toList()).orElseGet(() -> List.of(CYAN, MAGENTA, YELLOW, WHITE, BLACK));
    }

    public static List<InkColor> compounds() {
        return PastelRegistries.INK_COLOR.getTag(InkColorTags.COMPOUND_COLORS).map(entries -> entries.stream().map(Holder::value).toList()).orElseGet(() -> List.of(LIGHT_BLUE, BLUE, PURPLE, PINK, RED, ORANGE, LIME, GREEN, BROWN, GRAY, LIGHT_GRAY));
    }
}

