/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy.color;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.registries.PastelRegistries;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InkColor {
    public static final Codec<InkColor> CODEC = CodecHelper.SPECTRUM_DEFAULTED_IDENTIFIER.comapFlatMap(id -> InkColor.ofId(id).map(DataResult::success).orElse(DataResult.error(() -> "Not a valid ink color: " + String.valueOf(id))), InkColor::getID);
    public static final StreamCodec<ByteBuf, InkColor> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(id -> InkColor.ofId(id).orElseThrow(), InkColor::getID);
    protected static final Map<DyeColor, InkColor> DYE_TO_COLOR = new HashMap<DyeColor, InkColor>();
    protected final Optional<DyeColor> dyeColor;
    protected final int colorInt;
    protected final Vector3f colorVec;
    protected final int textColor;
    protected final Vector3f textColorVec;
    protected final ResourceLocation requiredAdvancement;

    public InkColor(DyeColor dyeColor, int color, ResourceLocation requiredAdvancement) {
        this(Optional.of(dyeColor), color, color, requiredAdvancement);
    }

    public InkColor(DyeColor dyeColor, int color, int textColor, ResourceLocation requiredAdvancement) {
        this(Optional.of(dyeColor), color, textColor, requiredAdvancement);
    }

    public InkColor(Optional<DyeColor> dyeColor, int color, int textColor, ResourceLocation requiredAdvancement) {
        this.dyeColor = dyeColor;
        this.colorInt = color;
        this.colorVec = ColorHelper.colorIntToVec(color);
        this.textColor = textColor;
        this.textColorVec = ColorHelper.colorIntToVec(textColor);
        this.requiredAdvancement = requiredAdvancement;
        dyeColor.ifPresent(value -> DYE_TO_COLOR.put((DyeColor)value, this));
    }

    @Nullable
    public static InkColor ofDyeColor(DyeColor dyeColor) {
        return DYE_TO_COLOR.get(dyeColor);
    }

    public static Optional<InkColor> ofId(ResourceLocation id) {
        return PastelRegistries.INK_COLOR.getOptional(id);
    }

    public static Optional<InkColor> ofIdString(String idString) {
        return PastelRegistries.INK_COLOR.getOptional(ResourceLocation.parse((String)idString));
    }

    public Optional<DyeColor> getDyeColor() {
        return this.dyeColor;
    }

    public String toString() {
        return this.getID().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InkColor that = (InkColor)o;
        return this.dyeColor.equals(that.dyeColor);
    }

    public int hashCode() {
        return this.colorInt;
    }

    public MutableComponent getName() {
        return Component.translatable((String)this.getID().toLanguageKey("ink", "name"));
    }

    public MutableComponent getColoredName() {
        return this.getName().setStyle(Style.EMPTY.withColor(this.textColor));
    }

    public MutableComponent getColoredInkName() {
        return Component.translatable((String)"ink.suffix", (Object[])new Object[]{this.getName()}).setStyle(Style.EMPTY.withColor(this.textColor));
    }

    public Vector3f getColorVec() {
        return this.colorVec;
    }

    public int getColorInt() {
        return this.colorInt;
    }

    public int getTextColorInt() {
        return this.textColor;
    }

    public Vector3f getTextColorVec() {
        return this.textColorVec;
    }

    public ResourceLocation getRequiredAdvancement() {
        return this.requiredAdvancement;
    }

    public ResourceLocation getID() {
        return PastelRegistries.INK_COLOR.getKey((Object)this);
    }

    public boolean isIn(TagKey<InkColor> tag) {
        return PastelRegistries.INK_COLOR.wrapAsHolder((Object)this).is(tag);
    }
}

