/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import earth.terrarium.pastel.PastelCommon;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface PlayerOwned {
    public static Player getPlayerEntityIfOnline(UUID ownerUUID) {
        if (ownerUUID != null && PastelCommon.getSidedServer() != null) {
            return PastelCommon.getSidedServer().getPlayerList().getPlayer(ownerUUID);
        }
        return null;
    }

    public UUID getOwnerUUID();

    public void setOwner(Player var1);

    default public boolean hasOwner() {
        return this.getOwnerUUID() != null;
    }

    default public boolean isOwner(Player playerEntity) {
        return playerEntity.getUUID().equals(this.getOwnerUUID());
    }

    @Nullable
    default public Player getOwnerIfOnline() {
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null && PastelCommon.getSidedServer() != null) {
            return PastelCommon.getSidedServer().getPlayerList().getPlayer(ownerUUID);
        }
        return null;
    }

    public static void writeOwnerUUID(CompoundTag nbt, UUID ownerUUID) {
        if (ownerUUID != null) {
            nbt.putUUID("OwnerUUID", ownerUUID);
        }
    }

    public static UUID readOwnerUUID(CompoundTag nbt) {
        if (nbt.contains("OwnerUUID")) {
            return nbt.getUUID("OwnerUUID");
        }
        return null;
    }

    public static void writeOwnerName(CompoundTag nbt, String ownerName) {
        if (ownerName != null) {
            nbt.putString("OwnerName", ownerName);
        }
    }

    public static String readOwnerName(CompoundTag nbt) {
        if (nbt.contains("OwnerName")) {
            return nbt.getString("OwnerName");
        }
        return "???";
    }
}

