/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.helpers.Support;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface MultiblockCrafter
extends Upgradeable,
PlayerOwned {
    public static final Vec3 RECIPE_STACK_VELOCITY = new Vec3(0.0, 0.3, 0.0);

    @Nullable
    public static <T extends Recipe<?>> T getRecipeFromNbt(@Nullable Level world, CompoundTag nbt, Class<T> recipeClass) {
        Optional recipe;
        String recipeString;
        if (nbt.contains("CurrentRecipe") && !(recipeString = nbt.getString("CurrentRecipe")).isEmpty() && (recipe = PastelCommon.getRecipeManager(world).flatMap(m -> m.byKey(ResourceLocation.parse((String)recipeString)))).isPresent() && recipeClass.isInstance(recipe.get())) {
            return (T)((RecipeHolder)recipe.get()).value();
        }
        return null;
    }

    @Nullable
    public static RecipeHolder<?> getRecipeEntryFromNbt(@Nullable Level world, CompoundTag nbt) {
        String recipeString;
        if (nbt.contains("CurrentRecipe") && !(recipeString = nbt.getString("CurrentRecipe")).isEmpty()) {
            return PastelCommon.getRecipeManager(world).flatMap(m -> m.byKey(ResourceLocation.parse((String)recipeString))).orElse(null);
        }
        return null;
    }

    @Nullable
    public static <R extends RecipeInput, T extends Recipe<R>> RecipeHolder<T> getRecipeEntryFromNbt(@Nullable Level world, CompoundTag nbt, Class<T> clazz) {
        RecipeHolder<?> entry = MultiblockCrafter.getRecipeEntryFromNbt(world, nbt);
        return entry == null ? null : new RecipeHolder(entry.id(), (Recipe)clazz.cast(entry.value()));
    }

    public static void spawnExperience(Level world, BlockPos blockPos, float amount, RandomSource random) {
        MultiblockCrafter.spawnExperience(world, blockPos, Support.chanceRound(amount, random));
    }

    public static void spawnExperience(Level world, BlockPos blockPos, int amount) {
        if (amount > 0) {
            ExperienceOrb experienceOrbEntity = new ExperienceOrb(world, (double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, amount);
            world.addFreshEntity((Entity)experienceOrbEntity);
        }
    }

    public static void spawnItemStackAsEntitySplitViaMaxCount(Level world, BlockPos blockPos, ItemStack itemStack, int amount, Vec3 velocity) {
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, Vec3.atCenterOf((Vec3i)blockPos), itemStack, amount, velocity, true, null);
    }

    public static void spawnItemStackAsEntitySplitViaMaxCount(Level world, Vec3 pos, ItemStack itemStack, int amount, Vec3 velocity, boolean neverDespawn, @Nullable Entity owner) {
        while (amount > 0) {
            int currentAmount = Math.min(amount, itemStack.getMaxStackSize());
            ItemStack resultStack = itemStack.copy();
            resultStack.setCount(currentAmount);
            ItemEntity itemEntity = new ItemEntity(world, pos.x(), pos.y(), pos.z(), resultStack);
            itemEntity.setDeltaMovement(velocity);
            if (neverDespawn) {
                itemEntity.setUnlimitedLifetime();
            }
            if (owner != null) {
                itemEntity.setTarget(owner.getUUID());
            }
            itemEntity.setExtendedLifetime();
            world.addFreshEntity((Entity)itemEntity);
            amount -= currentAmount;
        }
    }

    public static void spawnOutputAsItemEntity(Level world, BlockPos pos, ItemStack outputItemStack) {
        ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, outputItemStack);
        itemEntity.push(0.0, 0.1, 0.0);
        itemEntity.setExtendedLifetime();
        world.addFreshEntity((Entity)itemEntity);
    }
}

