/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.misc.VersionChangeHelper;
import earth.terrarium.pastel.PastelClient;
import earth.terrarium.pastel.PastelSided;
import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColorMixes;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.attachments.PastelDataAttachments;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.compat.PastelIntegrationPacks;
import earth.terrarium.pastel.config.PastelConfig;
import earth.terrarium.pastel.data_loaders.CrystalApothecarySimulationsDataLoader;
import earth.terrarium.pastel.data_loaders.EntityFishingDataLoader;
import earth.terrarium.pastel.data_loaders.NaturesStaffConversionDataLoader;
import earth.terrarium.pastel.entity.PastelEntitySubPredicateTypes;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.PastelTrackedDataHandlerRegistry;
import earth.terrarium.pastel.events.PastelDamageEvents;
import earth.terrarium.pastel.events.PastelEffectEvents;
import earth.terrarium.pastel.events.PastelEnchantmentEvents;
import earth.terrarium.pastel.events.PastelEntityEvents;
import earth.terrarium.pastel.events.PastelEquipmentEvents;
import earth.terrarium.pastel.events.PastelMiscEvents;
import earth.terrarium.pastel.events.PastelPlayerEvents;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.events.game.PastelPositionSources;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.loot.PastelLootContextTypes;
import earth.terrarium.pastel.loot.PastelLootFunctionTypes;
import earth.terrarium.pastel.loot.PastelLootModifiers;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.networking.PastelS2CPackets;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelArmorMaterials;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlockSoundGroups;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelCapabilityHandlers;
import earth.terrarium.pastel.registries.PastelCommands;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelDataMaps;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelEntityColorProcessors;
import earth.terrarium.pastel.registries.PastelFeatures;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelFusionShrineWorldEffects;
import earth.terrarium.pastel.registries.PastelItemDamageImmunities;
import earth.terrarium.pastel.registries.PastelItemGroups;
import earth.terrarium.pastel.registries.PastelItemProjectileBehaviors;
import earth.terrarium.pastel.registries.PastelItemProviders;
import earth.terrarium.pastel.registries.PastelItemSubPredicateTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.PastelLoadConditions;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelOmniAcceleratorProjectiles;
import earth.terrarium.pastel.registries.PastelPastelUpgrades;
import earth.terrarium.pastel.registries.PastelPotions;
import earth.terrarium.pastel.registries.PastelPresentUnpackBehaviors;
import earth.terrarium.pastel.registries.PastelRecipeScalings;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelResonanceProcessorTypes;
import earth.terrarium.pastel.registries.PastelResourceConditions;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.registries.PastelStampDataCategories;
import earth.terrarium.pastel.registries.PastelStructurePoolElementTypes;
import earth.terrarium.pastel.registries.PastelStructureTypes;
import earth.terrarium.pastel.registries.PastelTreeDecoratorTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="pastel")
public class PastelCommon {
    public static final String MOD_ID = "pastel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pastel");
    public static final Map<ResourceLocation, TagKey<Item>> CACHED_ITEM_TAG_MAP = new HashMap<ResourceLocation, TagKey<Item>>();
    public static PastelConfig CONFIG;

    public static void logInfo(String message) {
        LOGGER.info("[pastel] {}", (Object)message);
    }

    public static void logWarning(String message) {
        LOGGER.warn("[pastel] {}", (Object)message);
    }

    public static void logError(String message) {
        LOGGER.error("[pastel] {}", (Object)message);
    }

    public static ResourceLocation locate(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static ResourceLocation ofPastel(String id) {
        int i = id.indexOf(58);
        String path = id.substring(i + 1);
        String namespace = i > 0 ? id.substring(0, i) : MOD_ID;
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public PastelCommon(IEventBus pastelBus, ModContainer container) {
        PastelCommon.logInfo("Starting Common Startup");
        NeoForgeMod.enableMilkFluid();
        pastelBus.addListener(PastelRegistries::register);
        pastelBus.addListener(PastelRegistries::registerDyn);
        InkColors.register(pastelBus);
        InkColorMixes.register();
        PastelEntityAttributes.register(pastelBus);
        PastelLoadConditions.register(pastelBus);
        IngredientStack.register(pastelBus);
        PastelCommon.logInfo("Registering Component Types...");
        PastelDataComponentTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Block / Item Color Registries...");
        ColorRegistry.registerColorRegistries();
        PastelCommon.logInfo("Registering Status Effects...");
        PastelMobEffects.register(pastelBus);
        PastelCommon.logInfo("Registering Advancement Criteria...");
        PastelCriteria.register(pastelBus);
        PastelCommon.logInfo("Registering Particle Types...");
        PastelParticleTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Sound Events...");
        PastelSounds.register(pastelBus);
        PastelCommon.logInfo("Registering BlockSound Groups...");
        PastelBlockSoundGroups.register();
        PastelCommon.logInfo("Registering Fluids...");
        PastelFluids.register(pastelBus);
        PastelCommon.logInfo("Registering Armor Materials...");
        PastelArmorMaterials.register(pastelBus);
        PastelCommon.logInfo("Registering Blocks...");
        PastelBlocks.registerCommon(pastelBus);
        PastelCommon.logInfo("Registering Items...");
        PastelPotions.register(pastelBus);
        PastelItems.register(pastelBus);
        PastelItemGroups.register(pastelBus);
        pastelBus.addListener(PastelItemGroups::registerSpawnEggs);
        PastelCommon.logInfo("Registering Block Entities...");
        PastelBlockEntities.register(pastelBus);
        pastelBus.addListener(PastelBlockEntities::registerAdditionalTypes);
        PastelCommon.logInfo("Registering Capabilities...");
        pastelBus.addListener(PastelCapabilityHandlers::registerBlocks);
        pastelBus.addListener(PastelCapabilityHandlers::registerItems);
        PastelCommon.logInfo("Registering Data Attachments...");
        PastelDataAttachments.register(pastelBus);
        PastelCommon.logInfo("Registering Pastel Upgrades...");
        PastelPastelUpgrades.register(pastelBus);
        PastelCommon.logInfo("Registering Stamp Categories...");
        PastelStampDataCategories.register(pastelBus);
        PastelPresentUnpackBehaviors.register();
        PastelCommon.logInfo("Registering Features...");
        PastelFeatures.register(pastelBus);
        PastelCommon.logInfo("Registering Structure Types...");
        PastelStructureTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Dimension...");
        PastelLevels.register();
        PastelCommon.logInfo("Registering Recipe Types...");
        PastelRecipeScalings.init();
        PastelFusionShrineWorldEffects.register(pastelBus);
        PastelRecipeTypes.register(pastelBus);
        PastelRecipeSerializers.register(pastelBus);
        PastelCommon.logInfo("Registering Loot Conditions & Functions...");
        PastelLootContextTypes.register();
        PastelLootFunctionTypes.register(pastelBus);
        PastelLootModifiers.register(pastelBus);
        PastelCommon.logInfo("Setting up server side Mod Compat...");
        PastelIntegrationPacks.register(pastelBus);
        PastelCommon.logInfo("Registering Screen Handler Types...");
        PastelScreenHandlerTypes.registerMenus(pastelBus);
        PastelCommon.logInfo("Registering Default Item Stack Damage Immunities...");
        PastelItemDamageImmunities.registerDefaultItemStackImmunities();
        PastelCommon.logInfo("Registering Variant Specific Predicates...");
        PastelItemSubPredicateTypes.register(pastelBus);
        PastelEntitySubPredicateTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Entities...");
        PastelTrackedDataHandlerRegistry.register(pastelBus);
        PastelEntityTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Omni Accelerator Projectiles & Behaviors...");
        PastelOmniAcceleratorProjectiles.register();
        PastelItemProjectileBehaviors.register();
        PastelEntityColorProcessors.register();
        PastelItemProviders.register(pastelBus);
        PastelCommon.logInfo("Registering Commands...");
        NeoForge.EVENT_BUS.addListener(PastelCommands::register);
        PastelCommon.logInfo("Registering Networking Packets...");
        pastelBus.addListener(PastelC2SPackets::register);
        pastelBus.addListener(RegisterPayloadHandlersEvent.class, event -> {
            PayloadRegistrar registrar = event.registrar("1");
            PastelS2CPackets.register(registrar);
        });
        PastelCommon.logInfo("Registering Data Loaders...");
        NeoForge.EVENT_BUS.addListener(PastelCommon::registerReloadListeners);
        NeoForge.EVENT_BUS.addListener(Pastel::clearServerInstance);
        PastelCommon.logInfo("Adding to Fabric's Registries...");
        PastelCommon.logInfo("Registering Game Events...");
        PastelGameEvents.register(pastelBus);
        PastelPositionSources.register(pastelBus);
        PastelCommon.logInfo("Registering Dispenser, Resonance & Present Unwrap Behaviors...");
        PastelResonanceProcessorTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Resource Conditions...");
        PastelResourceConditions.register(pastelBus);
        PastelCommon.logInfo("Registering Structure WeightedPool Element Types...");
        PastelStructurePoolElementTypes.register(pastelBus);
        PastelCommon.logInfo("Registering Event Listeners...");
        PastelMiscEvents.register();
        PastelEntityEvents.register();
        PastelDamageEvents.register();
        PastelPlayerEvents.register();
        PastelEquipmentEvents.register();
        PastelEffectEvents.register(pastelBus);
        PastelEnchantmentEvents.register();
        PastelCommon.logInfo("Registering Tree Decorator Types...");
        PastelTreeDecoratorTypes.register(pastelBus);
        PastelDataMaps.register();
        PastelCommon.logInfo("Registering Builtin Resource Packs...");
        PastelCommon.logInfo("Common startup completed!");
        new PastelClient(pastelBus, container);
        VersionChangeHelper.registerPlayerListener((String)MOD_ID, (modId, from, to, player) -> DatabankUtils.recheckAdvancements((ServerPlayer)player));
    }

    private static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)NaturesStaffConversionDataLoader.INSTANCE);
        event.addListener((PreparableReloadListener)EntityFishingDataLoader.INSTANCE);
        event.addListener((PreparableReloadListener)CrystalApothecarySimulationsDataLoader.INSTANCE);
    }

    public static Optional<RecipeManager> getRecipeManager(@Nullable Level world) {
        return Optional.ofNullable(world).map(Level::getRecipeManager).or(() -> Optional.ofNullable(PastelCommon.getSidedServer()).map(MinecraftServer::getRecipeManager));
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        if (PastelCommon.getSidedServer() == null) {
            return null;
        }
        return PastelCommon.getSidedServer().registryAccess();
    }

    @Nullable
    public static MinecraftServer getSidedServer() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return ServerLifecycleHooks.getCurrentServer();
        }
        return PastelSided.getClientServer();
    }

    static {
        PastelCommon.logInfo("Loading config file...");
        AutoConfig.register(PastelConfig.class, JanksonConfigSerializer::new);
        CONFIG = (PastelConfig)AutoConfig.getConfigHolder(PastelConfig.class).getConfig();
        PastelCommon.logInfo("Finished loading config file.");
    }
}

