/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.mixin;

import com.mojang.datafixers.util.Pair;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.config.ModConfig;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={OverworldBiomeBuilder.class})
public class OverworldBiomeBuilderMixin {
    private static final Climate.Parameter JUNGLE_TEMPERATURE = Climate.Parameter.span((float)0.4f, (float)1.0f);
    private static final Climate.Parameter JUNGLE_HUMIDITY = Climate.Parameter.span((float)0.4f, (float)1.0f);
    private static final Climate.Parameter JUNGLE_CONTINENTALNESS = Climate.Parameter.span((float)0.5f, (float)1.0f);
    private static final Climate.Parameter JUNGLE_EROSION = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private static final Climate.Parameter JUNGLE_DEPTH = Climate.Parameter.span((float)0.2f, (float)0.9f);
    private static final Climate.Parameter JUNGLE_WEIRDNESS = Climate.Parameter.span((float)0.0f, (float)1.0f);
    private static final Climate.Parameter SPIDER_CAVE_TEMPERATURE = Climate.Parameter.span((float)-0.4f, (float)0.2f);
    private static final Climate.Parameter SPIDER_CAVE_HUMIDITY = Climate.Parameter.span((float)-1.0f, (float)-0.4f);
    private static final Climate.Parameter SPIDER_CAVE_CONTINENTALNESS = Climate.Parameter.span((float)0.5f, (float)1.0f);
    private static final Climate.Parameter SPIDER_CAVE_EROSION = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private static final Climate.Parameter SPIDER_CAVE_DEPTH = Climate.Parameter.span((float)0.2f, (float)0.9f);
    private static final Climate.Parameter SPIDER_CAVE_WEIRDNESS = Climate.Parameter.span((float)0.7f, (float)1.0f);
    private static final Climate.Parameter TUNDRA_TEMPERATURE = Climate.Parameter.span((float)-1.0f, (float)-0.5f);
    private static final Climate.Parameter TUNDRA_HUMIDITY = Climate.Parameter.span((float)0.0f, (float)1.0f);
    private static final Climate.Parameter TUNDRA_CONTINENTALNESS = Climate.Parameter.span((float)0.5f, (float)1.0f);
    private static final Climate.Parameter TUNDRA_EROSION = Climate.Parameter.span((float)0.0f, (float)1.0f);
    private static final Climate.Parameter TUNDRA_DEPTH = Climate.Parameter.span((float)0.2f, (float)0.9f);
    private static final Climate.Parameter TUNDRA_WEIRDNESS = Climate.Parameter.span((float)0.0f, (float)1.0f);
    private static final Climate.Parameter DESERT_TEMPERATURE = Climate.Parameter.span((float)0.6f, (float)1.0f);
    private static final Climate.Parameter DESERT_HUMIDITY = Climate.Parameter.span((float)-1.0f, (float)-0.4f);
    private static final Climate.Parameter DESERT_CONTINENTALNESS = Climate.Parameter.span((float)0.5f, (float)1.0f);
    private static final Climate.Parameter DESERT_EROSION = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private static final Climate.Parameter DESERT_DEPTH = Climate.Parameter.span((float)0.2f, (float)0.9f);
    private static final Climate.Parameter DESERT_WEIRDNESS = Climate.Parameter.span((float)0.0f, (float)1.0f);

    @Inject(at={@At(value="RETURN")}, method={"addUndergroundBiomes"})
    public void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, CallbackInfo ci) {
        if (UndergroundWorlds.isRegisterDone()) {
            if (ModConfig.GENERATE_UNDERGROUND_JUNGLE.get().booleanValue()) {
                consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)JUNGLE_TEMPERATURE, (Climate.Parameter)JUNGLE_HUMIDITY, (Climate.Parameter)JUNGLE_CONTINENTALNESS, (Climate.Parameter)JUNGLE_EROSION, (Climate.Parameter)JUNGLE_DEPTH, (Climate.Parameter)JUNGLE_WEIRDNESS, (float)0.0f), UndergroundWorlds.UNDERGROUND_JUNGLE));
            }
            if (ModConfig.GENERATE_SPIDER_CAVE.get().booleanValue()) {
                consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)SPIDER_CAVE_TEMPERATURE, (Climate.Parameter)SPIDER_CAVE_HUMIDITY, (Climate.Parameter)SPIDER_CAVE_CONTINENTALNESS, (Climate.Parameter)SPIDER_CAVE_EROSION, (Climate.Parameter)SPIDER_CAVE_DEPTH, (Climate.Parameter)SPIDER_CAVE_WEIRDNESS, (float)0.0f), UndergroundWorlds.SPIDER_CAVE));
            }
            if (ModConfig.GENERATE_UNDERGROUND_TUNDRA.get().booleanValue()) {
                consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)TUNDRA_TEMPERATURE, (Climate.Parameter)TUNDRA_HUMIDITY, (Climate.Parameter)TUNDRA_CONTINENTALNESS, (Climate.Parameter)TUNDRA_EROSION, (Climate.Parameter)TUNDRA_DEPTH, (Climate.Parameter)TUNDRA_WEIRDNESS, (float)0.0f), UndergroundWorlds.UNDERGROUND_TUNDRA));
            }
            if (ModConfig.GENERATE_UNDERGROUND_DESERT.get().booleanValue()) {
                consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)DESERT_TEMPERATURE, (Climate.Parameter)DESERT_HUMIDITY, (Climate.Parameter)DESERT_CONTINENTALNESS, (Climate.Parameter)DESERT_EROSION, (Climate.Parameter)DESERT_DEPTH, (Climate.Parameter)DESERT_WEIRDNESS, (float)0.0f), UndergroundWorlds.UNDERGROUND_DESERT));
            }
        }
    }
}

