/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.mixin;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.config.ModConfig;
import hexagonnico.undergroundworlds.items.ModToolTiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(at={@At(value="RETURN")}, method={"getTooltipLines"})
    private void getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> callbackInfo) {
        ItemStackMixin itemStackMixin = this;
        if (itemStackMixin instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)itemStackMixin;
            if (itemStack.is((Item)UndergroundWorlds.BLADE_OF_THE_JUNGLE.get()) && ModConfig.BLADE_OF_THE_JUNGLE_POISON_CHANCE.get() > 0.0) {
                ((List)callbackInfo.getReturnValue()).add(1, Component.translatable((String)(itemStack.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
            } else {
                TieredItem item;
                Item item2 = itemStack.getItem();
                if (item2 instanceof TieredItem && (item = (TieredItem)item2).getTier().equals((Object)ModToolTiers.FREEZING)) {
                    ((List)callbackInfo.getReturnValue()).add(1, Component.translatable((String)"item.modifiers.undergroundworlds.freezing").withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }
}

