/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.entities;

import hexagonnico.undergroundworlds.config.ModConfig;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Wrapped
extends Zombie {
    public Wrapped(EntityType<? extends Wrapped> type, Level world) {
        super(type, world);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (effect.getEffect().equals((Object)MobEffects.BLINDNESS)) {
            return false;
        }
        return super.canBeAffected(effect);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HUSK_AMBIENT;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.HUSK_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return SoundEvents.HUSK_DEATH;
    }

    @NotNull
    protected SoundEvent getStepSound() {
        return SoundEvents.HUSK_STEP;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (ModConfig.WRAPPED_BLINDNESS_TIME.get() > 0 && flag && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, ModConfig.WRAPPED_BLINDNESS_TIME.get() * 20), (Entity)this);
        }
        return flag;
    }

    protected boolean convertsInWater() {
        return false;
    }

    public void setBaby(boolean childZombie) {
    }

    @NotNull
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }
}

