/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.entities;

import hexagonnico.undergroundworlds.config.ModConfig;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class JungleZombie
extends Zombie {
    public JungleZombie(EntityType<? extends JungleZombie> type, Level world) {
        super(type, world);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (effect.getEffect().equals((Object)MobEffects.POISON)) {
            return false;
        }
        return super.canBeAffected(effect);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && (double)this.getRandom().nextFloat() < ModConfig.JUNGLE_ZOMBIE_POISON_CHANCE.get() && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.JUNGLE_ZOMBIE_POISON_TIME.get() * 20), (Entity)this);
        }
        return flag;
    }

    @NotNull
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }
}

