/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.entities;

import hexagonnico.undergroundworlds.config.ModConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JungleBee
extends Monster {
    public JungleBee(EntityType<? extends JungleBee> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public float getWalkTargetValue(@NotNull BlockPos pos, @NotNull LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.goalSelector.addGoal(8, (Goal)new WanderGoal());
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (super.doHurtTarget(target)) {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                switch (this.level().getDifficulty()) {
                    case EASY: {
                        if (!((double)this.getRandom().nextFloat() < ModConfig.JUNGLE_BEE_POISON_CHANCE_EASY.get())) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.JUNGLE_BEE_POISON_TIME_EASY.get() * 20), (Entity)this);
                        break;
                    }
                    case NORMAL: {
                        if (!((double)this.getRandom().nextFloat() < ModConfig.JUNGLE_BEE_POISON_CHANCE_NORMAL.get())) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.JUNGLE_BEE_POISON_TIME_NORMAL.get() * 20), (Entity)this);
                        break;
                    }
                    case HARD: {
                        if (!((double)this.getRandom().nextFloat() < ModConfig.JUNGLE_BEE_POISON_CHANCE_HARD.get())) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.JUNGLE_BEE_POISON_TIME_HARD.get() * 20), (Entity)this);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level world) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        flyingPathNavigation.setCanOpenDoors(false);
        flyingPathNavigation.setCanFloat(false);
        flyingPathNavigation.setCanPassDoors(true);
        return flyingPathNavigation;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.BEE_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return SoundEvents.BEE_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    protected void jumpInLiquid(@NotNull TagKey<Fluid> fluidTag) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    @NotNull
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.5 * (double)this.getEyeHeight(), (double)this.getBbWidth() * 0.2);
    }

    private class WanderGoal
    extends Goal {
        private WanderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return JungleBee.this.navigation.isDone() && JungleBee.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return JungleBee.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                JungleBee.this.navigation.moveTo(JungleBee.this.navigation.createPath(BlockPos.containing((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3 = JungleBee.this.getViewVector(0.0f);
            Vec3 vec32 = HoverRandomPos.getPos((PathfinderMob)JungleBee.this, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.getPos((PathfinderMob)JungleBee.this, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963267948966);
        }
    }
}

