/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import org.jetbrains.annotations.NotNull;

public class MudGrassBlock
extends Block
implements BonemealableBlock {
    private final ResourceKey<PlacedFeature> bonemealFeature = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"jungle_vegetation"));

    public MudGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeGrass(BlockState blockState, LevelReader world, BlockPos pos) {
        BlockPos posAbove = pos.above();
        BlockState blockStateAbove = world.getBlockState(posAbove);
        if (blockStateAbove.is(Blocks.SNOW) && (Integer)blockStateAbove.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockStateAbove.getFluidState().getAmount() == 8) {
            return false;
        }
        return LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)blockState, (BlockPos)pos, (BlockState)blockStateAbove, (BlockPos)posAbove, (Direction)Direction.UP, (int)blockStateAbove.getLightBlock((BlockGetter)world, posAbove)) < world.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState blockState, LevelReader world, BlockPos pos) {
        return MudGrassBlock.canBeGrass(blockState, world, pos) && !world.getFluidState(pos.above()).is(FluidTags.WATER);
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (world.getMaxLocalRawBrightness(pos.above()) >= 9) {
            BlockState defaultState = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos nextPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!world.getBlockState(nextPos).is(Blocks.MUD) || !MudGrassBlock.canPropagate(defaultState, (LevelReader)world, nextPos)) continue;
                world.setBlockAndUpdate(nextPos, defaultState);
            }
        }
        if (!MudGrassBlock.canBeGrass(state, (LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, Blocks.MUD.defaultBlockState());
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, @NotNull BlockState state) {
        return world.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        world.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(this.bonemealFeature).ifPresent(feature -> {
            ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
            for (int x = -3; x <= 3; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -3; z <= 3; ++z) {
                        BlockPos offsetPos = pos.offset(x, y, z);
                        BlockPos posAbove = offsetPos.above();
                        if (!random.nextBoolean() || !world.getBlockState(offsetPos).is(BlockTags.DIRT) || !world.getBlockState(posAbove).isAir()) continue;
                        ((PlacedFeature)feature.value()).place((WorldGenLevel)world, chunkGenerator, random, posAbove);
                    }
                }
            }
        });
    }
}

