/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public abstract class ModLoader {
    public abstract <T extends Item> Supplier<T> registerItem(String var1, Function<Item.Properties, T> var2);

    public Supplier<Item> registerItem(String name) {
        return this.registerItem(name, Item::new);
    }

    public abstract <T extends Block> Supplier<T> registerBlock(String var1, Function<BlockBehaviour.Properties, T> var2);

    public Supplier<BlockItem> registerBlockItem(String name, Supplier<? extends Block> block) {
        return this.registerItem(name, properties -> new BlockItem((Block)block.get(), properties));
    }

    public <T extends Block> Supplier<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> function) {
        Supplier<T> block = this.registerBlock(name, function);
        this.registerBlockItem(name, block);
        return block;
    }

    public <T extends Block> Supplier<T> registerBlockVariantAndItem(String name, Function<BlockBehaviour.Properties, T> function, Supplier<? extends Block> base) {
        return this.registerBlockAndItem(name, properties -> (Block)function.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)base.get()))));
    }

    public Supplier<Block> registerBlockVariantAndItem(String name, Supplier<? extends Block> base) {
        return this.registerBlockVariantAndItem(name, Block::new, base);
    }

    public abstract <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String var1, BiFunction<BlockPos, BlockState, T> var2, Supplier<Set<Block>> var3);

    public abstract <T extends Entity> Supplier<EntityType<T>> registerEntity(String var1, EntityType.Builder<T> var2);

    public Supplier<SpawnEggItem> registerSpawnEgg(String name, Supplier<EntityType<? extends Mob>> entity, int primaryColor, int secondaryColor) {
        return this.registerItem(name, properties -> new SpawnEggItem((EntityType)entity.get(), primaryColor, secondaryColor, properties));
    }

    public abstract <T extends Feature<?>> Supplier<T> registerFeature(String var1, Supplier<T> var2);

    public abstract Supplier<Holder<ArmorMaterial>> registerArmorMaterial(String var1, Supplier<ArmorMaterial> var2);

    public abstract <T extends StructureProcessor> Supplier<StructureProcessorType<T>> registerStructureProcessor(String var1, Supplier<MapCodec<T>> var2);

    public abstract Supplier<LootItemConditionType> registerLootCondition(String var1, Supplier<MapCodec<? extends LootItemCondition>> var2);

    public abstract String getName();

    public abstract boolean isModLoaded(String var1);

    public abstract boolean isRegisterDone();

    public abstract boolean isDevelopmentEnvironment();
}

