/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class SaxaulTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<SaxaulTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> SaxaulTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, SaxaulTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public SaxaulTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.SAXAUL_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        Direction trunkOffset = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction trunkOffset2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction directionUnvalidated = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction direction = directionUnvalidated == trunkOffset.getOpposite() ? directionUnvalidated.getOpposite() : directionUnvalidated;
        Direction forkedDirectionUnvalidated = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction forkedDirection = forkedDirectionUnvalidated == direction || forkedDirectionUnvalidated == trunkOffset ? forkedDirectionUnvalidated.getOpposite() : forkedDirectionUnvalidated;
        for (int i = 0; i < height; ++i) {
            boolean validator;
            int j = startPos.getY() + i;
            BlockPos.MutableBlockPos mutablePos1 = mutable.set(startPos.getX(), j, startPos.getZ());
            BlockPos pos2 = mutablePos1.relative(trunkOffset);
            BlockPos pos3 = pos2.relative(trunkOffset2);
            BlockPos.MutableBlockPos blockPos = i >= 2 ? (trunkOffset != trunkOffset2 ? pos3 : pos2) : mutablePos1;
            int l = Math.max(1, Math.toIntExact(Math.round(Math.pow(0.4, i - 1) * (double)(height - 1))));
            float float1 = random.nextFloat();
            BlockPos.MutableBlockPos forkedMutablePos1 = mutable2.set(startPos.getX(), j, startPos.getZ());
            BlockPos forkedPos2 = forkedMutablePos1.relative(trunkOffset.getOpposite()).relative(Direction.DOWN);
            BlockPos forkedPos3 = forkedPos2.relative(trunkOffset2.getOpposite());
            BlockPos forkedBlockPos = trunkOffset.getOpposite() != trunkOffset2.getOpposite() ? forkedPos3 : forkedPos2;
            boolean bl = validator = l < 3;
            if (i == 2) {
                this.placeLog(world, replacer, random, (BlockPos)blockPos, config);
                this.placeLog(world, replacer, random, forkedBlockPos, config);
            }
            this.placeLog(world, replacer, random, (BlockPos)blockPos, config);
            if (i >= 2) {
                this.placeLog(world, replacer, random, forkedBlockPos, config);
            }
            if (validator) {
                if (float1 < this.placeBranchPerLogProbability) {
                    this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, j, direction, l);
                    this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, j, forkedDirection, l);
                }
                if ((double)float1 < (double)this.placeBranchPerLogProbability - 0.25) {
                    this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, j, direction.getClockWise().getClockWise(), l);
                    this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, j, forkedDirection.getClockWise().getClockWise(), l);
                }
            }
            if (i == height - 1) {
                list.add(new FoliagePlacer.FoliageAttachment(blockPos.above(1), 0, false));
            }
            direction = direction.getClockWise().getClockWise();
            forkedDirection = forkedDirection.getClockWise().getClockWise();
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction, int length) {
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction direction2 = random.nextFloat() < 0.5f ? direction.getClockWise() : direction.getCounterClockWise();
        int nextBetween = random.nextIntBetweenInclusive(3, 5);
        boolean bl = random.nextFloat() < 0.5f;
        boolean bl3 = random.nextBoolean();
        boolean bl4 = false;
        for (int l = 0; l < length; ++l) {
            Direction.Axis axis;
            int m = yOffset + l / nextBetween;
            if (bl) {
                k += direction2.getStepZ();
                if (bl3) {
                    j += direction2.getStepX();
                }
                bl = random.nextFloat() < 0.8f;
                axis = direction2.getAxis();
            } else {
                axis = direction.getAxis();
                k += direction.getStepZ();
                if (bl3) {
                    j += direction.getStepX();
                }
            }
            this.placeLog(world, replacer, random, (BlockPos)mutable.set(j, m, k), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
            if (l + 1 == length) {
                BlockPos blockPos = new BlockPos(j, m + 1, k);
                nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
            }
            if (!(random.nextFloat() < 0.4f) || bl4 || l <= length / 3) continue;
            this.generateSecondaryBranch(world, replacer, random, config, nodes, (BlockPos)mutable, m, direction2);
            bl4 = true;
        }
    }

    private void generateSecondaryBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction) {
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 1; ++l) {
            this.placeLog(world, replacer, random, (BlockPos)mutable.set(j += direction.getStepX(), yOffset, k += direction.getStepZ()), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
            BlockPos blockPos = new BlockPos(j, yOffset + 1, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    protected boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return super.validTreePos(world, pos) || world.isStateAtPosition(pos, state -> state.is(this.canGrowThrough));
    }
}

