/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PaloVerdeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<PaloVerdeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PaloVerdeTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, PaloVerdeTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public PaloVerdeTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.PALO_VERDE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        Direction trunkOffset = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction trunkOffset2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        boolean bl = random.nextBoolean();
        for (int i = 0; i < height; ++i) {
            BlockPos forkedBlockPos;
            int j = startPos.getY() + i;
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockPos.MutableBlockPos mutablePos1 = mutable.set(startPos.getX(), j, startPos.getZ());
            BlockPos pos2 = mutablePos1.relative(trunkOffset);
            BlockPos pos3 = pos2.relative(trunkOffset2);
            BlockPos.MutableBlockPos blockPos = i >= 2 ? (trunkOffset != trunkOffset2 ? pos3 : pos2) : mutablePos1;
            int l = Math.toIntExact(Math.round(Math.pow(random.nextGaussian(), 0.15f) * 3.5)) - 1;
            float float1 = random.nextFloat();
            float float2 = random.nextFloat();
            if (i == 2) {
                this.placeLog(world, replacer, random, (BlockPos)mutablePos1, config);
            }
            if (this.placeLog(world, replacer, random, (BlockPos)blockPos, config) && i < height - 1) {
                int m = height + i - 5;
                if (i > 1 && l > 0) {
                    this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction, l, m);
                    if ((double)float1 < (double)this.placeBranchPerLogProbability - 0.35) {
                        this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction.getClockWise(), l, m);
                    }
                    if ((double)float1 < (double)this.placeBranchPerLogProbability - 0.65) {
                        this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction.getClockWise().getClockWise(), l, m);
                    }
                }
            }
            if (i == height - 1) {
                list.add(new FoliagePlacer.FoliageAttachment(blockPos.above(1), 0, false));
            }
            if (!bl || i < 2) continue;
            Direction forkedDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockPos.MutableBlockPos forkedMutablePos1 = mutable2.set(startPos.getX(), j, startPos.getZ());
            BlockPos forkedPos2 = forkedMutablePos1.relative(trunkOffset.getOpposite()).relative(Direction.DOWN);
            BlockPos forkedPos3 = forkedPos2.relative(trunkOffset2.getOpposite());
            BlockPos blockPos2 = forkedBlockPos = trunkOffset.getOpposite() != trunkOffset2.getOpposite() ? forkedPos3 : forkedPos2;
            if (i == 2) {
                this.placeLog(world, replacer, random, (BlockPos)forkedMutablePos1, config);
            }
            if (this.placeLog(world, replacer, random, forkedBlockPos, config) && i < height - 1) {
                int m = height + i - 5;
                if (i > 1 && l > 0) {
                    this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection, l, m);
                    if ((double)float2 < (double)this.placeBranchPerLogProbability - 0.35) {
                        this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection.getClockWise(), l, m);
                    }
                    if ((double)float2 < (double)this.placeBranchPerLogProbability - 0.65) {
                        this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection.getClockWise().getClockWise(), l, m);
                    }
                }
            }
            if (i != height - 2) continue;
            list.add(new FoliagePlacer.FoliageAttachment(forkedBlockPos.above(1), 0, false));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int height, int yOffset, Direction direction, int length, int steps) {
        int i = yOffset + length;
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.nextFloat() < 0.5f;
        Direction direction2 = random.nextFloat() < 0.5f ? direction.getClockWise() : direction.getCounterClockWise();
        for (int l = length; l < height - 3 && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int m = Math.round(yOffset + l / 5);
            j += direction.getStepX();
            k = bl ? (k += Math.max(0, direction2.getStepZ() - random.nextInt(2))) : (k += direction.getStepZ());
            if (!this.placeLog(world, replacer, random, (BlockPos)mutable.set(j, m, k), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()))) continue;
            i = m + 1;
        }
        if (i - yOffset >= 1) {
            BlockPos blockPos = new BlockPos(j, i, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    protected boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return super.validTreePos(world, pos) || world.isStateAtPosition(pos, state -> state.is(this.canGrowThrough));
    }
}

