/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class OliveTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<OliveTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> OliveTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, OliveTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public OliveTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.OLIVE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockPos = startPos.below();
        OliveTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        OliveTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.east(), (TreeConfiguration)config);
        OliveTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.south(), (TreeConfiguration)config);
        OliveTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.south().east(), (TreeConfiguration)config);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            int j = startPos.getY() + i;
            BlockPos.MutableBlockPos mutablePos1 = mutable.set(startPos.getX(), j, startPos.getZ());
            this.placeLog(world, replacer, random, (BlockPos)mutablePos1, config);
            this.placeLog(world, replacer, random, mutablePos1.east(), config);
            this.placeLog(world, replacer, random, mutablePos1.south(), config);
            this.placeLog(world, replacer, random, mutablePos1.south().east(), config);
            if (i == 0) {
                this.placeLog(world, replacer, random, this.getRoot(random, mutablePos1), config);
                this.placeLog(world, replacer, random, this.getRoot(random, mutablePos1), config);
            }
            if (i != height - 1) continue;
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.north(1), j, Direction.NORTH, this.extraBranchSteps.sample(random));
            if ((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.west(1), j, Direction.WEST, this.extraBranchSteps.sample(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.south(2), j, Direction.SOUTH, this.extraBranchSteps.sample(random));
            if ((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.south(2), j, Direction.WEST, this.extraBranchSteps.sample(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.east(2), j, Direction.EAST, this.extraBranchSteps.sample(random));
            if ((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.east(2), j, Direction.NORTH, this.extraBranchSteps.sample(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.south(2).east(), j, Direction.WEST, this.extraBranchSteps.sample(random));
            if (!((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.65)) continue;
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.south().east(2), j, Direction.SOUTH, this.extraBranchSteps.sample(random));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction, int steps) {
        int m = yOffset;
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.nextBoolean();
        Direction direction2 = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
        int l = 0;
        while (steps > 0) {
            boolean bl2 = random.nextBoolean();
            m = yOffset + l;
            if (bl2 && l != 0) {
                j += direction.getStepX();
                k = bl ? (k += Math.max(0, direction2.getStepZ() - random.nextInt(2))) : (k += direction.getStepZ());
            }
            int finalL = l++;
            this.placeLog(world, replacer, random, (BlockPos)mutable.set(j, m, k), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)(bl2 || finalL == 0 ? direction.getAxis() : Direction.Axis.Y)));
            --steps;
        }
        if (m - yOffset >= 1) {
            nodes.add(new FoliagePlacer.FoliageAttachment(new BlockPos(j, m, k), 0, false));
        }
    }

    protected boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return super.validTreePos(world, pos) || world.isStateAtPosition(pos, state -> state.is(this.canGrowThrough));
    }

    protected BlockPos getRoot(RandomSource random, BlockPos.MutableBlockPos mutablePos1) {
        return switch (random.nextInt(7)) {
            case 1 -> mutablePos1.east(2);
            case 2 -> mutablePos1.south(2);
            case 3 -> mutablePos1.south(2).east();
            case 4 -> mutablePos1.west();
            case 5 -> mutablePos1.east().north();
            case 6 -> mutablePos1.south().east(2);
            case 7 -> mutablePos1.south().west();
            default -> mutablePos1.north();
        };
    }
}

