/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class MahoganyTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<MahoganyTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> MahoganyTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MahoganyTrunkPlacer::new));

    public MahoganyTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.MAHOGANY_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        BlockPos blockPos = startPos.below();
        MahoganyTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        MahoganyTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.east(), (TreeConfiguration)config);
        MahoganyTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.south(), (TreeConfiguration)config);
        MahoganyTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.south().east(), (TreeConfiguration)config);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        ArrayList nodes = Lists.newArrayList();
        for (int i = 0; i < height; ++i) {
            this.setLog(world, replacer, random, mutable, config, startPos, 0, i, 0);
            if (i >= height - 1) continue;
            this.setLog(world, replacer, random, mutable, config, startPos, 1, i, 0);
            this.setLog(world, replacer, random, mutable, config, startPos, 1, i, 1);
            this.setLog(world, replacer, random, mutable, config, startPos, 0, i, 1);
            if (i <= height - 9 || !((double)random.nextFloat() < 0.85) || i % 2 != 0) continue;
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            this.generateExtraBranch(world, replacer, random, config, nodes, startPos.relative(direction.getClockWise(), 1), i, direction, random.nextIntBetweenInclusive(6, 9), 1);
            if ((double)random.nextFloat() < 0.75) {
                this.generateExtraBranch(world, replacer, random, config, nodes, startPos, i, direction.getClockWise(), random.nextIntBetweenInclusive(6, 9), 1);
            }
            if ((double)random.nextFloat() < 0.75) {
                this.generateExtraBranch(world, replacer, random, config, nodes, startPos.relative(direction.getClockWise(), 1), i, direction.getClockWise().getClockWise(), random.nextIntBetweenInclusive(6, 9), 1);
            }
            this.generateExtraBranch(world, replacer, random, config, nodes, startPos, i, direction.getClockWise().getClockWise().getClockWise(), random.nextIntBetweenInclusive(6, 9), 1);
        }
        this.generateExtraBranch(world, replacer, random, config, nodes, startPos.north(1), height - 1, Direction.EAST, random.nextIntBetweenInclusive(5, 7), 0);
        this.generateExtraBranch(world, replacer, random, config, nodes, startPos, height - 1, Direction.WEST, random.nextIntBetweenInclusive(5, 7), 0);
        this.generateExtraBranch(world, replacer, random, config, nodes, startPos.east(1), height - 1, Direction.SOUTH, random.nextIntBetweenInclusive(5, 7), 0);
        this.generateExtraBranch(world, replacer, random, config, nodes, startPos, height - 1, Direction.NORTH, random.nextIntBetweenInclusive(5, 7), 0);
        return nodes;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction, int length, int foliageRadius) {
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction direction2 = random.nextFloat() < 0.5f ? direction.getClockWise() : direction.getCounterClockWise();
        int nextBetween = random.nextIntBetweenInclusive(2, 4);
        boolean bl = random.nextFloat() < 0.5f;
        boolean bl2 = false;
        boolean bl3 = random.nextBoolean();
        boolean bl4 = false;
        for (int l = 0; l < length; ++l) {
            Direction.Axis axis;
            int m = pos.getY() + (yOffset + l / nextBetween);
            if (bl) {
                k += direction2.getStepZ();
                if (bl3) {
                    j += direction2.getStepX();
                }
                bl = random.nextFloat() < 0.8f;
                axis = direction2.getAxis();
            } else {
                axis = direction.getAxis();
                k += direction.getStepZ();
                if (bl3) {
                    j += direction.getStepX();
                }
            }
            this.placeLog(world, replacer, random, (BlockPos)mutable.set(j, m, k), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
            if (l + 1 == length) {
                BlockPos blockPos = new BlockPos(j, m, k);
                nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
            }
            if (random.nextFloat() < 0.4f && !bl2 && l > length / 3) {
                this.generateSecondaryBranch(world, replacer, random, config, nodes, (BlockPos)mutable, m, direction2.getOpposite());
                bl2 = true;
            }
            if (!(random.nextFloat() < 0.4f) || bl4 || l <= length / 3) continue;
            this.generateSecondaryBranch(world, replacer, random, config, nodes, (BlockPos)mutable, m, direction2);
            bl4 = true;
        }
    }

    private void generateSecondaryBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction) {
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 4; ++l) {
            this.placeLog(world, replacer, random, (BlockPos)mutable.set(j += direction.getStepX(), yOffset, k += direction.getStepZ()), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
            if (l + 1 != 4) continue;
            BlockPos blockPos = new BlockPos(j, yOffset, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    private void setLog(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, BlockPos.MutableBlockPos tmpPos, TreeConfiguration config, BlockPos startPos, int dx, int dy, int dz) {
        tmpPos.setWithOffset((Vec3i)startPos, dx, dy, dz);
        this.placeLogIfFree(world, replacer, random, tmpPos, config);
    }
}

