/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class GhafTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<GhafTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> GhafTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, GhafTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public GhafTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.GHAF_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.nextBoolean();
        boolean bl2 = random.nextBoolean();
        Direction trunkOffset = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction trunkOffset2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        for (int i = 0; i < height; ++i) {
            BlockPos.MutableBlockPos blockPos;
            int j = startPos.getY() + i;
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            Direction direction2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            Direction direction3 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockPos.MutableBlockPos mutablePos1 = mutable.set(startPos.getX(), j, startPos.getZ());
            BlockPos pos2 = mutablePos1.relative(trunkOffset);
            BlockPos pos3 = pos2.relative(trunkOffset2);
            Object object = bl && i >= 2 ? (bl2 && trunkOffset != trunkOffset2 ? pos3 : pos2) : (blockPos = mutablePos1);
            if (bl && i == 2) {
                this.placeLog(world, replacer, random, (BlockPos)mutablePos1, config);
            }
            if (this.placeLog(world, replacer, random, (BlockPos)blockPos, config) && i < height - 1 && random.nextFloat() < this.placeBranchPerLogProbability) {
                int k = this.extraBranchLength.sample(random);
                int l = Math.max(0, k - this.extraBranchLength.sample(random) - 1);
                int m = height + i - 7;
                if (i > 2) {
                    this.generateExtraBranch(world, replacer, random, height, config, list, (BlockPos)blockPos, j, direction, l, m, i);
                    if ((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.25) {
                        this.generateExtraBranch(world, replacer, random, height, config, list, (BlockPos)blockPos, j, direction2, l, Math.round(m / 2), i);
                    }
                    if ((double)random.nextFloat() < (double)this.placeBranchPerLogProbability - 0.55) {
                        this.generateExtraBranch(world, replacer, random, height, config, list, (BlockPos)blockPos, j, direction3, l, Math.round(m / 2), i);
                    }
                }
            }
            if (i != height - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment(blockPos.above(1), 0, false));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction, int length, int steps, int b) {
        int i = yOffset + length;
        int j = pos.getX();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.nextFloat() < 0.5f;
        Direction direction2 = random.nextFloat() < 0.5f ? direction.getClockWise() : direction.getCounterClockWise();
        for (int l = length; l < height && steps > 0 && steps < (bl ? 7 : 10); ++l, --steps) {
            if (l < 1) continue;
            int m = Math.round(yOffset + l / 5);
            j += direction.getStepX();
            k = bl ? (k += Math.max(0, direction2.getStepZ() - random.nextInt(2))) : (k += direction.getStepZ());
            i = m;
            if (!this.placeLog(world, replacer, random, (BlockPos)mutable.set(j, m, k), config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()))) continue;
            i = m + 1;
        }
        if (i - yOffset >= 1) {
            BlockPos blockPos = new BlockPos(j, i, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    protected boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return super.validTreePos(world, pos) || world.isStateAtPosition(pos, state -> state.is(this.canGrowThrough));
    }
}

