/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CoconutTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CoconutTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CoconutTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("trunk_steps").forGetter(trunkPlacer -> trunkPlacer.trunkSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fork_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.forkProbability)), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, CoconutTrunkPlacer::new));
    private final IntProvider trunkSteps;
    private final float forkProbability;
    private final HolderSet<Block> canGrowThrough;

    public CoconutTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider trunkSteps, float forkProbability, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.trunkSteps = trunkSteps;
        this.forkProbability = forkProbability;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return NSWorldGen.COCONUT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(startPos.getX(), startPos.getY() - 1, startPos.getZ());
        BlockPos.MutableBlockPos forkedMutable = new BlockPos.MutableBlockPos().set(startPos.getX(), startPos.getY() + 1, startPos.getZ());
        boolean forked = random.nextFloat() < this.forkProbability;
        int steps = this.trunkSteps.sample(random);
        int increment = random.nextIntBetweenInclusive(0, 1);
        int forkedIncrement = random.nextIntBetweenInclusive(0, 1);
        Direction offsetDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction offsetDirection2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int forkedOffset = random.nextIntBetweenInclusive(0, 2);
        int forkedHeight = height - forkedOffset;
        for (int i = 0; i < height; ++i) {
            BlockPos.MutableBlockPos pos = mutable.move(0, 1, 0);
            this.placeLog(world, replacer, random, (BlockPos)pos, config);
            if (i < 2) continue;
            if (forked && i < forkedHeight) {
                BlockPos.MutableBlockPos forkedPos = forkedMutable.move(0, 1, 0);
                this.placeLog(world, replacer, random, (BlockPos)forkedPos, config);
                if (i == forkedHeight - 1) {
                    list.add(new FoliagePlacer.FoliageAttachment(forkedPos.above(1), 0, false));
                }
            }
            if (i == height - 1) {
                list.add(new FoliagePlacer.FoliageAttachment(pos.above(1), 0, false));
            }
            if (increment == 0) {
                mutable.move(offsetDirection);
                if (offsetDirection2 != offsetDirection) {
                    mutable.move(offsetDirection2);
                }
                increment = height / steps - random.nextIntBetweenInclusive(-1, 1);
            }
            if (forkedIncrement == 0) {
                forkedMutable.move(offsetDirection.getOpposite());
                if (offsetDirection2 != offsetDirection && random.nextBoolean()) {
                    forkedMutable.move(offsetDirection2.getOpposite());
                }
                forkedIncrement = forkedHeight / steps - random.nextIntBetweenInclusive(-1, 1);
            }
            --increment;
            --forkedIncrement;
        }
        return list;
    }

    protected boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return super.validTreePos(world, pos) || world.isStateAtPosition(pos, state -> state.is(this.canGrowThrough));
    }
}

