/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class WisteriaVinesTreeDecorator
extends TreeDecorator {
    public static final MapCodec<WisteriaVinesTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(treeDecorator -> treeDecorator.blockProvider), (App)BlockStateProvider.CODEC.fieldOf("block_provider2").forGetter(treeDecorator -> treeDecorator.blockProvider2), (App)BlockStateProvider.CODEC.fieldOf("block_provider3").forGetter(treeDecorator -> treeDecorator.blockProvider3), (App)BlockStateProvider.CODEC.fieldOf("block_provider4").forGetter(treeDecorator -> treeDecorator.blockProvider4), (App)Codec.intRange((int)0, (int)10).fieldOf("number").forGetter(treeDecorator -> treeDecorator.number)).apply((Applicative)instance, WisteriaVinesTreeDecorator::new));
    protected final BlockStateProvider blockProvider;
    protected final BlockStateProvider blockProvider2;
    protected final BlockStateProvider blockProvider3;
    protected final BlockStateProvider blockProvider4;
    private final float probability;
    protected int number;

    public WisteriaVinesTreeDecorator(float probability, BlockStateProvider blockProvider, BlockStateProvider blockProvider2, BlockStateProvider blockProvider3, BlockStateProvider blockProvider4, int number) {
        this.probability = probability;
        this.blockProvider = blockProvider;
        this.blockProvider2 = blockProvider2;
        this.blockProvider3 = blockProvider3;
        this.blockProvider4 = blockProvider4;
        this.number = number;
    }

    private static void placeVines(BlockPos pos, BlockStateProvider block, BlockStateProvider block2, BlockStateProvider block3, BlockStateProvider block4, TreeDecorator.Context generator, int number) {
        RandomSource random = generator.random();
        generator.setBlock(pos, block3.getState(random, pos));
        if (!generator.isAir(pos.above(2)) || !generator.isAir(pos.above(3))) {
            generator.setBlock(pos.above(), block4.getState(random, pos));
        }
        pos = pos.below();
        while (number > 0) {
            if (generator.isAir(pos)) {
                if (number == 1 || !generator.isAir(pos.below()) || random.nextBoolean()) {
                    generator.setBlock(pos, block2.getState(random, pos));
                    break;
                }
                generator.setBlock(pos, block.getState(random, pos));
            }
            pos = pos.below();
            --number;
        }
    }

    protected TreeDecoratorType<?> type() {
        return NSWorldGen.WISTERIA_VINES_TREE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        context.leaves().forEach(blockPos -> {
            BlockPos blockPos2;
            if (randomSource.nextFloat() < this.probability && context.isAir(blockPos2 = blockPos.below())) {
                WisteriaVinesTreeDecorator.placeVines(blockPos2, this.blockProvider, this.blockProvider2, this.blockProvider4, this.blockProvider3, context, this.number);
            }
        });
    }
}

