/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class RedwoodBranchTreeDecorator
extends TreeDecorator {
    public static final MapCodec<RedwoodBranchTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.probability)), (App)BlockStateProvider.CODEC.fieldOf("leaf_provider").forGetter(treeDecorator -> treeDecorator.leaf_provider)).apply((Applicative)instance, RedwoodBranchTreeDecorator::new));
    private final float probability;
    private final BlockStateProvider leaf_provider;

    public RedwoodBranchTreeDecorator(float probability, BlockStateProvider leaf_provider) {
        this.probability = probability;
        this.leaf_provider = leaf_provider;
    }

    protected TreeDecoratorType<?> type() {
        return NSWorldGen.REDWOOD_BRANCH_DECORATOR.get();
    }

    public void place(TreeDecorator.Context generator) {
        RandomSource random = generator.random();
        ObjectArrayList list = generator.logs();
        ObjectArrayList list2 = generator.leaves();
        list.stream().filter(arg_0 -> RedwoodBranchTreeDecorator.lambda$place$3((List)list2, (List)list, arg_0)).forEach(pos -> {
            if (random.nextFloat() <= this.probability) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                BlockPos.MutableBlockPos blockPos = pos.offset(direction.getStepX(), 0, direction.getStepZ()).mutable();
                if (generator.isAir((BlockPos)blockPos)) {
                    generator.setBlock((BlockPos)blockPos, this.leaf_provider.getState(random, (BlockPos)blockPos));
                }
                blockPos.move(direction.getClockWise());
                if (generator.isAir((BlockPos)blockPos)) {
                    generator.setBlock((BlockPos)blockPos, this.leaf_provider.getState(random, (BlockPos)blockPos));
                }
                blockPos.move(direction.getClockWise().getOpposite(), 2);
                if (generator.isAir((BlockPos)blockPos)) {
                    generator.setBlock((BlockPos)blockPos, this.leaf_provider.getState(random, (BlockPos)blockPos));
                }
                blockPos.move(direction.getClockWise()).move(direction);
                if (generator.isAir((BlockPos)blockPos)) {
                    generator.setBlock((BlockPos)blockPos, this.leaf_provider.getState(random, (BlockPos)blockPos));
                }
                blockPos.move(direction.getOpposite()).move(Direction.UP);
                if (generator.isAir((BlockPos)blockPos)) {
                    generator.setBlock((BlockPos)blockPos, this.leaf_provider.getState(random, (BlockPos)blockPos));
                }
            }
        });
    }

    private static /* synthetic */ boolean lambda$place$3(List list2, List list, BlockPos pos) {
        return pos.getY() < ((BlockPos)list2.get(0)).getY() - 2 && pos.getY() > ((BlockPos)list.get(0)).getY() + 2;
    }
}

