/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.hibiscus.naturespirit.blocks.PolyporeBlock;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PolyporeTreeDecorator
extends TreeDecorator {
    public static final MapCodec<PolyporeTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("big_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.big_probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("small_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.small_probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(treeDecorator -> Float.valueOf(treeDecorator.chance)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(treeDecorator -> treeDecorator.block_provider), (App)BlockStateProvider.CODEC.fieldOf("polypore_provider").forGetter(treeDecorator -> treeDecorator.polypore_provider)).apply((Applicative)instance, PolyporeTreeDecorator::new));
    private final float big_probability;
    private final float small_probability;
    private final float chance;
    private final BlockStateProvider block_provider;
    private final BlockStateProvider polypore_provider;

    public PolyporeTreeDecorator(float big_probability, float small_probability, float chance, BlockStateProvider block_provider, BlockStateProvider polypore_provider) {
        this.chance = chance;
        this.big_probability = big_probability;
        this.small_probability = small_probability;
        this.block_provider = block_provider;
        this.polypore_provider = polypore_provider;
    }

    protected TreeDecoratorType<?> type() {
        return NSWorldGen.POLYPORE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context generator) {
        RandomSource random = generator.random();
        if (random.nextFloat() < this.chance) {
            ObjectArrayList list = generator.logs();
            list.stream().filter(arg_0 -> PolyporeTreeDecorator.lambda$place$6((List)list, arg_0)).forEach(pos -> {
                Direction direction2;
                if (random.nextFloat() <= this.big_probability) {
                    for (Direction direction : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                        if (!generator.isAir(pos.relative(direction))) continue;
                        direction2 = direction.getClockWise();
                        Direction direction3 = direction.getCounterClockWise();
                        int radius = random.nextIntBetweenInclusive(1, 2);
                        if (generator.isAir(pos.relative(direction2)) && generator.isAir(pos.relative(direction2).relative(direction))) {
                            this.generateSquare(generator, (BlockPos)pos, radius, direction, direction2, random);
                            break;
                        }
                        if (!generator.isAir(pos.relative(direction3)) || !generator.isAir(pos.relative(direction3).relative(direction))) continue;
                        this.generateSquare(generator, (BlockPos)pos, radius, direction, direction3, random);
                        break;
                    }
                }
                if (random.nextFloat() <= this.small_probability) {
                    for (Direction direction : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                        if (!generator.isAir(pos.relative(direction))) continue;
                        direction2 = direction.getClockWise();
                        generator.setBlock(pos.relative(direction), (BlockState)this.polypore_provider.getState(random, pos.relative(direction)).trySetValue((Property)PolyporeBlock.FACING, (Comparable)direction));
                        if (!generator.isAir(pos.relative(direction2))) break;
                        generator.setBlock(pos.relative(direction2), (BlockState)this.polypore_provider.getState(random, pos.relative(direction2)).trySetValue((Property)PolyporeBlock.FACING, (Comparable)direction2));
                        break;
                    }
                }
            });
        }
    }

    protected void generateSquare(TreeDecorator.Context generator, BlockPos cornerPos, int radius, Direction direction1, Direction direction2, RandomSource random) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)cornerPos);
        for (int j = 0; j <= radius; ++j) {
            for (int k = 0; k <= radius; ++k) {
                BlockPos blockPos = mutable.relative(direction2, k).relative(direction1, j);
                if (!generator.isAir(blockPos)) continue;
                generator.setBlock(blockPos, (BlockState)this.block_provider.getState(random, blockPos).trySetValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private static /* synthetic */ boolean lambda$place$6(List list, BlockPos pos) {
        return pos.getY() < ((BlockPos)list.get(0)).getY() + 6 && pos.getY() > ((BlockPos)list.get(0)).getY();
    }
}

