/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.hibiscus.naturespirit.blocks.ShiitakeMushroomPlantBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MapleGroundTreeDecorator
extends TreeDecorator {
    public static final MapCodec<MapleGroundTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("inner_block").forGetter(treeDecorator -> treeDecorator.provider), (App)BlockStateProvider.CODEC.fieldOf("outer_block").forGetter(treeDecorator -> treeDecorator.provider2)).apply((Applicative)instance, MapleGroundTreeDecorator::new));
    private final BlockStateProvider provider;
    private final BlockStateProvider provider2;

    public MapleGroundTreeDecorator(BlockStateProvider provider, BlockStateProvider provider2) {
        this.provider = provider;
        this.provider2 = provider2;
    }

    protected TreeDecoratorType<?> type() {
        return NSWorldGen.MAPLE_GROUND_TREE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context generator) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list3 = generator.logs();
        list.addAll(list3);
        if (!list.isEmpty()) {
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(pos -> pos.getY() == i).forEach(pos -> this.setArea(generator, (BlockPos)pos));
        }
    }

    private void setArea(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                if (Math.abs(i) == 2 || Math.abs(j) == 2) {
                    this.setColumn2(generator, origin.offset(i, 0, j));
                    continue;
                }
                this.setColumn(generator, origin.offset(i, 0, j));
            }
        }
    }

    private void setColumn(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockPos = origin.above(i);
            if (Feature.isGrassOrDirt((LevelSimulatedReader)generator.level(), (BlockPos)blockPos)) {
                generator.setBlock(blockPos, this.provider.getState(generator.random(), origin));
                break;
            }
            if (!generator.isAir(blockPos) && i < 0) break;
        }
    }

    private void setColumn2(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockPos = origin.above(i);
            if (Feature.isGrassOrDirt((LevelSimulatedReader)generator.level(), (BlockPos)blockPos)) {
                generator.setBlock(blockPos, this.provider2.getState(generator.random(), origin));
                if (!generator.isAir(blockPos.above(1)) || generator.random().nextInt(50) != 0) break;
                generator.setBlock(blockPos.above(1), ((ShiitakeMushroomPlantBlock)((Object)NSBlocks.SHIITAKE_MUSHROOM.get())).defaultBlockState());
                break;
            }
            if (!generator.isAir(blockPos) && i < 0) break;
        }
    }
}

