/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class MapleFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<MapleFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> MapleFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)4, (int)16).fieldOf("height").forGetter(foliagePlacer -> foliagePlacer.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesExtensionChance)))).apply((Applicative)instance, MapleFoliagePlacer::new));
    private final IntProvider height;
    private final float hangingLeavesChance;
    private final float hangingLeavesExtensionChance;

    public MapleFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        super(radius, offset);
        this.height = height;
        this.hangingLeavesChance = hangingLeavesChance;
        this.hangingLeavesExtensionChance = hangingLeavesExtensionChance;
    }

    protected FoliagePlacerType<?> type() {
        return NSWorldGen.MAPLE_FOLIAGE_PLACER_TYPE.get();
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        boolean bl = treeNode.doubleTrunk();
        BlockPos blockPos = treeNode.pos().above(offset);
        int i = radius + treeNode.radiusOffset() - 1;
        this.placeLeavesRow(world, placer, random, config, blockPos, i - 2, foliageHeight - 3, bl);
        this.placeLeavesRow(world, placer, random, config, blockPos, i - 1, foliageHeight - 4, bl);
        for (int j = foliageHeight - 5; j >= 0; --j) {
            this.placeLeavesRow(world, placer, random, config, blockPos, i, j, bl);
        }
        this.placeLeavesRowWithHangingLeavesBelow(world, placer, random, config, blockPos, i, -1, bl, this.hangingLeavesChance, this.hangingLeavesExtensionChance);
        this.placeLeavesRowWithHangingLeavesBelow(world, placer, random, config, blockPos, i - 1, -2, bl, this.hangingLeavesChance, this.hangingLeavesExtensionChance);
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.height.sample(random);
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        boolean bl2;
        if (y >= -1 && y <= 0 && (dx == radius || dz == radius || dx == radius - y || dz == radius - y)) {
            return true;
        }
        boolean bl = dx == radius && dz == radius;
        boolean bl3 = bl2 = radius > 2;
        if (bl2) {
            return bl || dx + dz > radius * 2 - 2;
        }
        return bl;
    }
}

