/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class GroundedBushFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<GroundedBushFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> GroundedBushFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)1, (int)512).fieldOf("foliage_height").forGetter(placer -> placer.foliageHeight), (App)Codec.intRange((int)0, (int)256).fieldOf("leaf_placement_attempts").forGetter(placer -> placer.leafPlacementAttempts))).apply((Applicative)instance, GroundedBushFoliagePlacer::new));
    private final IntProvider foliageHeight;
    private final int leafPlacementAttempts;

    public GroundedBushFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider foliageHeight, int leafPlacementAttempts) {
        super(radius, offset);
        this.foliageHeight = foliageHeight;
        this.leafPlacementAttempts = leafPlacementAttempts;
    }

    protected FoliagePlacerType<?> type() {
        return NSWorldGen.GROUNDED_BUSH_PLACER_TYPE.get();
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.pos().below();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        for (int i = 0; i <= foliageHeight; ++i) {
            for (int j = 0; j < this.leafPlacementAttempts / (i + 1); ++j) {
                mutable.setWithOffset((Vec3i)blockPos, random.nextInt(radius) - random.nextInt(radius), i, random.nextInt(radius) - random.nextInt(radius));
                if (world.isStateAtPosition(mutable.below(), Predicate.isEqual(Blocks.AIR.defaultBlockState()))) continue;
                GroundedBushFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.foliageHeight.sample(random);
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

