/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class FirFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<FirFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FirFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, FirFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public FirFoliagePlacer(IntProvider intProvider, IntProvider intProvider2, IntProvider trunkHeight) {
        super(intProvider, intProvider2);
        this.trunkHeight = trunkHeight;
    }

    protected FoliagePlacerType<?> type() {
        return NSWorldGen.FIR_FOLIAGE_PLACER_TYPE.get();
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.pos();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        boolean nextBoolean = random.nextBoolean();
        boolean nextBoolean2 = random.nextBoolean();
        int i = random.nextInt(3);
        boolean j = true;
        boolean k = false;
        for (int l = offset; l >= -foliageHeight - 2; --l) {
            Direction n;
            Direction m;
            if (l >= offset - 2) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (nextBoolean && !nextBoolean2 && l == offset) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                }
                if ((nextBoolean || nextBoolean2) && l == offset - 1) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                }
                if (l != offset - 2) continue;
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                continue;
            }
            if (l == offset - 3) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.getRandom((RandomSource)random), 1).relative(Direction.getRandom((RandomSource)random), 1).above(1));
                }
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 4) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
                }
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 5) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    m = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                    n = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(m, 1).relative(n, 1));
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(m.getOpposite(), 1).relative(n.getOpposite(), 1));
                }
                if (!random.nextBoolean()) continue;
                m = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                n = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(m, 1).relative(n, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(m.getOpposite(), 1).relative(n.getOpposite(), 1));
                continue;
            }
            if (l == offset - 6) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    m = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                    n = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(m, 1).relative(n, 1).above(1));
                }
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 7) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
                }
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 8) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
                }
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 2));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.EAST, 2));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 2));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.WEST, 2));
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 9) {
                this.placeLeavesRow(world, placer, random, config, blockPos, 2, l, treeNode.doubleTrunk());
                continue;
            }
            if (l == offset - 10) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
                }
                if (random.nextBoolean()) {
                    FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
                }
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 2).relative(Direction.EAST, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 2).relative(Direction.WEST, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.EAST, 2).relative(Direction.NORTH, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.EAST, 2).relative(Direction.SOUTH, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 2).relative(Direction.EAST, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 2).relative(Direction.WEST, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.WEST, 2).relative(Direction.NORTH, 1));
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.WEST, 2).relative(Direction.SOUTH, 1));
                this.placeLeavesRow(world, placer, random, config, blockPos, 1, l, treeNode.doubleTrunk());
                continue;
            }
            if (l != offset - 11) continue;
            mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
            if (random.nextBoolean()) {
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
            }
            if (random.nextBoolean()) {
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
            }
            if (random.nextBoolean()) {
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
            }
            if (!random.nextBoolean()) continue;
            FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
        }
    }

    protected void placeLeavesRow(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.shouldSkipLocationSigned(random, j, y, k, radius, giantTrunk)) continue;
                mutable.setWithOffset((Vec3i)centerPos, j, y, k);
                FirFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return Math.max(8, trunkHeight - this.trunkHeight.sample(random));
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && radius > 0;
    }
}

