/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CoconutFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CoconutFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CoconutFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CoconutFoliagePlacer::new));

    public CoconutFoliagePlacer(IntProvider intProvider, IntProvider intProvider2) {
        super(intProvider, intProvider2);
    }

    protected FoliagePlacerType<?> type() {
        return NSWorldGen.COCONUT_FOLIAGE_PLACER_TYPE.get();
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.pos();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        for (int l = -2; l <= foliageHeight; ++l) {
            if (l == -2) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(2, 0, 0));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-2, 0, 0));
                continue;
            }
            if (l == -1) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(2, 0, 0));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-2, 0, 0));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(1, 0, 0));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 1));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -1));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-1, 0, 0));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, 2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, 2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, -2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, -2));
                continue;
            }
            if (l == 0) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                this.placeLeavesRow(world, placer, random, config, (BlockPos)mutable, 1, 0, false);
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, 2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, 2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, -2));
                CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, -2));
                continue;
            }
            if (l == 1) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                this.placeLeavesRow(world, placer, random, config, (BlockPos)mutable, 1, 0, false);
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(2, 0, 0));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -2));
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-2, 0, 0));
                continue;
            }
            if (l != 2) continue;
            mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(2, 0, 0));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 2));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -2));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-2, 0, 0));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(3, 0, 0));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, 3));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(0, 0, -3));
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.offset(-3, 0, 0));
            CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, 2));
            CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, 2));
            CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(-2, 0, -2));
            CoconutFoliagePlacer.placeFoliageBlock2(world, placer, random, config, mutable.offset(2, 0, -2));
        }
    }

    protected void placeLeavesRow(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                mutable.setWithOffset((Vec3i)centerPos, j, y, k);
                CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected static boolean placeFoliageBlock2(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos pos) {
        if (!TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos)) {
            return false;
        }
        BlockState blockState = config.foliageProvider.getState(random, pos);
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
        }
        if (blockState.hasProperty((Property)LeavesBlock.DISTANCE)) {
            blockState = (BlockState)blockState.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(5));
        }
        placer.set(pos, blockState);
        return true;
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return 2;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

