/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.hibiscus.naturespirit.world.feature.TurnipRootFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TurnipRootFeature
extends Feature<TurnipRootFeatureConfig> {
    public TurnipRootFeature(Codec<TurnipRootFeatureConfig> codec) {
        super(codec);
    }

    private static boolean hasSpaceForTree(WorldGenLevel world, TurnipRootFeatureConfig config, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 1; i <= config.requiredVerticalSpaceForTree; ++i) {
            mutable.move(Direction.UP);
            BlockState blockState = world.getBlockState((BlockPos)mutable);
            if (TurnipRootFeature.isAirOrWater(blockState, i, config.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState state, int height, int allowedVerticalWaterForTree) {
        if (state.isAir()) {
            return true;
        }
        int i = height + 1;
        return i <= allowedVerticalWaterForTree && state.getFluidState().is(FluidTags.WATER);
    }

    private static boolean generateTreeAndRoots(WorldGenLevel world, ChunkGenerator generator, TurnipRootFeatureConfig config, RandomSource random, BlockPos.MutableBlockPos mutablePos, BlockPos pos) {
        for (int i = 0; i < config.maxRootColumnHeight; ++i) {
            mutablePos.move(Direction.UP);
            if (!config.predicate.test((Object)world, (Object)mutablePos) || !TurnipRootFeature.hasSpaceForTree(world, config, (BlockPos)mutablePos)) continue;
            BlockPos blockPos = mutablePos.below();
            if (world.getFluidState(blockPos).is(FluidTags.LAVA) || !world.getBlockState(blockPos).isSolid()) {
                return false;
            }
            if (!((PlacedFeature)config.feature.value()).place(world, generator, random, (BlockPos)mutablePos)) continue;
            TurnipRootFeature.generateRootsColumn(pos, pos.getY() + i, world, config, random);
            return true;
        }
        return false;
    }

    private static void generateRootsColumn(BlockPos pos, int maxY, WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random) {
        int i = pos.getX();
        int j = pos.getZ();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int k = pos.getY(); k < maxY; ++k) {
            TurnipRootFeature.generateRoots(world, config, random, i, j, mutable.set(i, k, j));
        }
    }

    private static void generateRoots(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, int x, int z, BlockPos.MutableBlockPos mutablePos) {
        int i = config.rootRadius;
        Predicate<BlockState> predicate = state -> state.is(config.rootReplaceable);
        for (int j = 0; j < config.rootPlacementAttempts; ++j) {
            mutablePos.setWithOffset((Vec3i)mutablePos, random.nextInt(i) - random.nextInt(i), 0, random.nextInt(i) - random.nextInt(i));
            if (predicate.test(world.getBlockState((BlockPos)mutablePos))) {
                world.setBlock((BlockPos)mutablePos, config.rootStateProvider.getState(random, (BlockPos)mutablePos), 2);
            }
            mutablePos.setX(x);
            mutablePos.setZ(z);
        }
    }

    private static void generateHangingRoots(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.hangingRootPlacementAttempts; ++k) {
            BlockState blockState;
            mutablePos.setWithOffset((Vec3i)pos, random.nextInt(i) - random.nextInt(i), random.nextInt(j) - random.nextInt(j), random.nextInt(i) - random.nextInt(i));
            if (!world.isEmptyBlock((BlockPos)mutablePos) || !(blockState = config.hangingRootStateProvider.getState(random, (BlockPos)mutablePos)).canSurvive((LevelReader)world, (BlockPos)mutablePos) || !world.getBlockState(mutablePos.above()).isFaceSturdy((BlockGetter)world, (BlockPos)mutablePos, Direction.DOWN)) continue;
            world.setBlock((BlockPos)mutablePos, blockState, 2);
        }
    }

    private static void generateTurnips(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.turnipPlacementAttempts; ++k) {
            BlockState blockState;
            mutablePos.setWithOffset((Vec3i)pos, random.nextInt(i) - random.nextInt(i), random.nextInt(j) - random.nextInt(j), random.nextInt(i) - random.nextInt(i));
            if (world.getBlockState(mutablePos.relative(Direction.UP, 1)) != config.rootStateProvider.getState(random, (BlockPos)mutablePos) || !(blockState = config.turnipStateProvider.getState(random, (BlockPos)mutablePos)).canSurvive((LevelReader)world, (BlockPos)mutablePos) || !world.getBlockState(mutablePos.above()).isFaceSturdy((BlockGetter)world, (BlockPos)mutablePos, Direction.DOWN)) continue;
            world.setBlock((BlockPos)mutablePos, blockState, 2);
        }
    }

    public boolean place(FeaturePlaceContext<TurnipRootFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.level();
        RandomSource random = context.random();
        BlockPos blockPos = context.origin();
        TurnipRootFeatureConfig turnipRootFeatureConfig = (TurnipRootFeatureConfig)context.config();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        if (TurnipRootFeature.generateTreeAndRoots(structureWorldAccess, context.chunkGenerator(), turnipRootFeatureConfig, random, mutable, blockPos)) {
            TurnipRootFeature.generateHangingRoots(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
            TurnipRootFeature.generateTurnips(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
        }
        return true;
    }
}

