/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PolyporeFeature
extends Feature<NoneFeatureConfiguration> {
    public PolyporeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        for (Direction direction : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
            BlockPos pos2 = pos.relative(direction);
            if (world.isEmptyBlock(pos2)) continue;
            Direction direction2 = direction.getClockWise();
            Direction direction3 = direction.getCounterClockWise();
            int radius = random.nextIntBetweenInclusive(1, 3);
            if (world.isEmptyBlock(pos2.relative(direction2)) && world.isEmptyBlock(pos.relative(direction2))) {
                PolyporeFeature.generateSquare((LevelAccessor)world, pos2, radius, direction.getOpposite(), direction2);
                return true;
            }
            if (!world.isEmptyBlock(pos2.relative(direction3)) || !world.isEmptyBlock(pos.relative(direction3))) continue;
            PolyporeFeature.generateSquare((LevelAccessor)world, pos2, radius, direction.getOpposite(), direction3);
            return true;
        }
        return false;
    }

    protected static void generateSquare(LevelAccessor world, BlockPos cornerPos, int radius, Direction direction1, Direction direction2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)cornerPos);
        for (int j = 0; j <= radius; ++j) {
            for (int k = 0; k <= radius; ++k) {
                BlockPos blockPos = mutable.relative(direction2, k).relative(direction1, j);
                if (!world.isEmptyBlock(blockPos) && !world.getBlockState(blockPos).is(NSBlocks.GRAY_POLYPORE)) continue;
                world.setBlock(blockPos, (BlockState)((HugeMushroomBlock)NSBlocks.GRAY_POLYPORE_BLOCK.get()).defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }
}

