/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class NSDeltaFeature
extends Feature<DeltaFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_REPLACE = ImmutableList.of((Object)Blocks.BEDROCK, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER, (Object)((Block)NSBlocks.WISTERIA.getBlueLeaves().get()), (Object)((Block)NSBlocks.WISTERIA.getPurpleLeaves().get()), (Object)((Block)NSBlocks.WISTERIA.getWhiteLeaves().get()), (Object)((Block)NSBlocks.WISTERIA.getPinkLeaves().get()), (Object)((Block)NSBlocks.WILLOW.getLeaves().get()), (Object[])new Block[0]);
    private static final ImmutableList<Block> CAN_REPLACE = ImmutableList.of((Object)Blocks.DIRT, (Object)Blocks.COARSE_DIRT, (Object)Blocks.GRASS_BLOCK, (Object)Blocks.MUD, (Object)Blocks.SAND, (Object)((Block)NSBlocks.PINK_SAND.get()));
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final double RIM_SPAWN_CHANCE = 0.9;

    public NSDeltaFeature(Codec<DeltaFeatureConfiguration> codec) {
        super(codec);
    }

    private static boolean isClear(LevelAccessor level, BlockPos pos, DeltaFeatureConfiguration config) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(config.contents().getBlock())) {
            return false;
        }
        if (CANNOT_REPLACE.contains((Object)blockState.getBlock())) {
            return false;
        }
        if (CAN_REPLACE.contains((Object)blockState.getBlock()) && !blockState.is(config.contents().getBlock())) {
            for (Direction direction : DIRECTIONS) {
                boolean bl2;
                boolean bl = level.getBlockState(pos.relative(direction)).isAir();
                boolean bl3 = bl2 = !level.getFluidState(pos.relative(direction).below()).is(FluidTags.WATER);
                if ((!bl || direction == Direction.UP || !bl2 && !((double)level.getRandom().nextFloat() < 0.7)) && (bl || direction != Direction.UP)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean place(FeaturePlaceContext<DeltaFeatureConfiguration> context) {
        BlockPos blockPos2;
        boolean bl = false;
        RandomSource randomSource = context.random();
        WorldGenLevel worldGenLevel = context.level();
        DeltaFeatureConfiguration deltaFeatureConfiguration = (DeltaFeatureConfiguration)context.config();
        BlockPos blockPos = context.origin();
        boolean bl2 = randomSource.nextDouble() < 0.9;
        int i = bl2 ? deltaFeatureConfiguration.rimSize().sample(randomSource) : 0;
        int j = bl2 ? deltaFeatureConfiguration.rimSize().sample(randomSource) : 0;
        boolean bl3 = bl2 && i != 0 && j != 0;
        int k = deltaFeatureConfiguration.size().sample(randomSource);
        int l = deltaFeatureConfiguration.size().sample(randomSource);
        int m = Math.max(k, l);
        Iterator var14 = BlockPos.withinManhattan((BlockPos)blockPos, (int)k, (int)0, (int)l).iterator();
        while (var14.hasNext() && (blockPos2 = (BlockPos)var14.next()).distManhattan((Vec3i)blockPos) <= m) {
            BlockPos blockPos3;
            if (!NSDeltaFeature.isClear((LevelAccessor)worldGenLevel, blockPos2, deltaFeatureConfiguration)) continue;
            if (bl3) {
                bl = true;
                worldGenLevel.setBlock(blockPos2, deltaFeatureConfiguration.rim(), 3);
            }
            if (!NSDeltaFeature.isClear((LevelAccessor)worldGenLevel, blockPos3 = blockPos2.offset(i, 0, j), deltaFeatureConfiguration)) continue;
            bl = true;
            worldGenLevel.setBlock(blockPos3, deltaFeatureConfiguration.contents(), 3);
            worldGenLevel.scheduleTick(blockPos3, (Fluid)Fluids.WATER, 1);
        }
        return bl;
    }
}

