/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.hibiscus.naturespirit.blocks.BranchingTrunkBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class JoshuaTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public JoshuaTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        return JoshuaTreeFeature.generate2((LevelAccessor)structureWorldAccess, blockPos, random, 0);
    }

    private static boolean isSurroundedByAir(LevelReader world, BlockPos pos, @Nullable Direction exceptDirection) {
        Direction direction;
        Iterator var3 = Direction.Plane.HORIZONTAL.iterator();
        do {
            if (var3.hasNext()) continue;
            return true;
        } while ((direction = (Direction)var3.next()) == exceptDirection || world.isEmptyBlock(pos.relative(direction)));
        return false;
    }

    private static boolean generate2(LevelAccessor world, BlockPos pos, RandomSource random, int layer) {
        BranchingTrunkBlock branchingTrunkBlock = (BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get());
        int i = random.nextIntBetweenInclusive(1, 3);
        if (layer == 0) {
            i += 2;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockPos = pos.above(j + 1);
            if (!JoshuaTreeFeature.isSurroundedByAir((LevelReader)world, blockPos, Direction.DOWN)) {
                return false;
            }
            world.setBlock(blockPos, branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos), 2);
            world.setBlock(blockPos.below(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos.below()), 2);
            world.setBlock(blockPos, branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos), 2);
            if (layer <= 0) continue;
            world.setBlock(blockPos.below(2), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos.below(2)), 2);
        }
        if (layer < 2) {
            int k = random.nextIntBetweenInclusive(3, 5);
            if (layer == 0) {
                ++k;
            }
            for (int l = 0; l < k; ++l) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                int m = random.nextIntBetweenInclusive(1, 2);
                int n = Math.max(1, i - m);
                BlockPos blockPos2 = pos.above(n).relative(direction, m);
                if (!world.isEmptyBlock(blockPos2) || !JoshuaTreeFeature.isSurroundedByAir((LevelReader)world, blockPos2, direction.getOpposite())) continue;
                world.setBlock(blockPos2, branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2), 2);
                world.setBlock(blockPos2.relative(direction.getOpposite()), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getOpposite())), 2);
                for (int p = m; p > 0; --p) {
                    world.setBlock(blockPos2.relative(direction.getOpposite(), p), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getOpposite(), p)), 2);
                }
                JoshuaTreeFeature.generate2(world, blockPos2.above(), random, layer + 1);
                if (world.isEmptyBlock(blockPos2.above())) {
                    world.setBlock(blockPos2.above(), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
                    world.setBlock(blockPos2, ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, blockPos2), 2);
                    Direction direction2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    if (!(random.nextFloat() < 0.65f) || !world.isEmptyBlock(blockPos2.relative(direction, 1))) continue;
                    world.setBlock(blockPos2.relative(direction2, 1), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
                    world.setBlock(blockPos2, ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, blockPos2), 2);
                    continue;
                }
                if (!world.isEmptyBlock(blockPos2.above(2)) || world.isEmptyBlock(blockPos2.above())) continue;
                world.setBlock(blockPos2.above(2), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
                world.setBlock(blockPos2.above(1), ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, blockPos2.above()), 2);
                Direction direction2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                if (!(random.nextFloat() < 0.65f) || !world.isEmptyBlock(blockPos2.above().relative(direction, 1))) continue;
                world.setBlock(blockPos2.above().relative(direction2, 1), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
                world.setBlock(blockPos2.above(), ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, blockPos2.above()), 2);
            }
            return true;
        }
        world.setBlock(pos.above(i), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        world.setBlock(pos.above(i - 1), ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, pos.above(i - 1)), 2);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        if (world.isEmptyBlock(pos.above(i - 1).relative(direction, 1))) {
            world.setBlock(pos.above(i - 1).relative(direction, 1), (BlockState)((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
            world.setBlock(pos.above(i - 1), ((BranchingTrunkBlock)((Object)NSBlocks.JOSHUA.getLog().get())).withConnectionProperties((BlockGetter)world, pos.above(i - 1)), 2);
        }
        return true;
    }
}

