/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeShiitakeMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeShiitakeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected void makeCap(LevelAccessor world, RandomSource random, BlockPos start, int y, BlockPos.MutableBlockPos mutable, HugeMushroomFeatureConfiguration config) {
        for (int i = y - 3; i <= y + 1; ++i) {
            int j = i < y ? config.foliageRadius : config.foliageRadius - 1;
            int k = config.foliageRadius - 2;
            for (int l = -j; l <= j; ++l) {
                for (int m = -j; m <= j; ++m) {
                    boolean bl6;
                    boolean bl = l == -j;
                    boolean bl2 = l == j;
                    boolean bl3 = m == -j;
                    boolean bl4 = m == j;
                    boolean bl5 = bl || bl2;
                    boolean bl7 = bl6 = bl3 || bl4;
                    if (i < y && (bl5 == bl6 || i != y - 2 && i != y - 1)) continue;
                    mutable.setWithOffset((Vec3i)start, l, i, m);
                    if (world.getBlockState((BlockPos)mutable).isSolidRender((BlockGetter)world, (BlockPos)mutable)) continue;
                    BlockState blockState = config.capProvider.getState(random, start);
                    if (blockState.hasProperty((Property)HugeMushroomBlock.WEST) && blockState.hasProperty((Property)HugeMushroomBlock.EAST) && blockState.hasProperty((Property)HugeMushroomBlock.NORTH) && blockState.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockState.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(i >= y - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(l < -k))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(l > k))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(m < -k))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(m > k));
                    }
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                }
            }
        }
    }

    protected boolean isValidPosition(LevelAccessor world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfiguration config) {
        int i = pos.getY();
        if (i >= world.getMinBuildHeight() + 1 && i + height + 1 < world.getMaxBuildHeight()) {
            BlockState blockState = world.getBlockState(pos.below());
            if (!HugeShiitakeMushroomFeature.isDirt((BlockState)blockState) && !blockState.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int j = 0; j <= height; ++j) {
                int n = this.getTreeRadiusForHeight(-1, -1, config.foliageRadius, j);
            }
            return true;
        }
        return false;
    }

    protected int getTreeRadiusForHeight(int i, int j, int capSize, int y) {
        int k = 0;
        if (y < j && y >= j - 4) {
            k = capSize;
        } else if (y == j) {
            k = capSize;
        }
        return k;
    }
}

