/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import net.hibiscus.naturespirit.world.feature.HugeMushroomFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public abstract class HugeMushroomFeature
extends Feature<HugeMushroomFeatureConfig> {
    public HugeMushroomFeature(Codec<HugeMushroomFeatureConfig> codec) {
        super(codec);
    }

    protected void generateStem(LevelAccessor world, RandomSource random, BlockPos pos, HugeMushroomFeatureConfig config, int height, BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.set((Vec3i)pos).move(Direction.UP, i);
            if (world.getBlockState((BlockPos)mutablePos).isSolidRender((BlockGetter)world, (BlockPos)mutablePos)) continue;
            this.setBlock((LevelWriter)world, (BlockPos)mutablePos, config.stemProvider.getState(random, pos));
        }
    }

    protected int getHeight(RandomSource random, HugeMushroomFeatureConfig hugeMushroomFeatureConfig) {
        return random.nextIntBetweenInclusive(hugeMushroomFeatureConfig.firstRandomHeight, hugeMushroomFeatureConfig.secondRandomHeight) + hugeMushroomFeatureConfig.baseHeight;
    }

    protected boolean canGenerate(LevelAccessor world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfig config) {
        int i = pos.getY();
        if (i >= world.getMinBuildHeight() + 1 && i + height + 1 < world.getMaxBuildHeight()) {
            BlockState blockState = world.getBlockState(pos.below());
            if (!HugeMushroomFeature.isDirt((BlockState)blockState) && !blockState.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int j = 0; j <= height; ++j) {
                int k = this.getCapSize(-1, -1, config.foliageRadius, j);
                for (int l = -k; l <= k; ++l) {
                    for (int m = -k; m <= k; ++m) {
                        BlockState blockState2 = world.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, l, j, m));
                        if (blockState2.isAir() || blockState2.is(BlockTags.LEAVES)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfig> context) {
        BlockPos.MutableBlockPos mutable;
        HugeMushroomFeatureConfig hugeMushroomFeatureConfig;
        RandomSource random;
        int i;
        BlockPos blockPos;
        WorldGenLevel structureWorldAccess = context.level();
        if (!this.canGenerate((LevelAccessor)structureWorldAccess, blockPos = context.origin(), i = this.getHeight(random = context.random(), hugeMushroomFeatureConfig = (HugeMushroomFeatureConfig)context.config()), mutable = new BlockPos.MutableBlockPos(), hugeMushroomFeatureConfig)) {
            return false;
        }
        this.generateCap((LevelAccessor)structureWorldAccess, random, blockPos, i, mutable, hugeMushroomFeatureConfig);
        this.generateStem((LevelAccessor)structureWorldAccess, random, blockPos, hugeMushroomFeatureConfig, i, mutable);
        return true;
    }

    protected abstract int getCapSize(int var1, int var2, int var3, int var4);

    protected abstract void generateCap(LevelAccessor var1, RandomSource var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, HugeMushroomFeatureConfig var6);
}

