/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.hibiscus.naturespirit.blocks.GrowingBranchingTrunkBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class AlluaudiaFeature
extends Feature<NoneFeatureConfiguration> {
    public AlluaudiaFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        AlluaudiaFeature.generate2((LevelAccessor)structureWorldAccess, blockPos, random, blockPos, 6, 0);
        return true;
    }

    private static boolean isSurroundedByAir(LevelReader world, BlockPos pos, @Nullable Direction exceptDirection) {
        Direction direction;
        Iterator var3 = Direction.Plane.HORIZONTAL.iterator();
        do {
            if (var3.hasNext()) continue;
            return true;
        } while ((direction = (Direction)var3.next()) == exceptDirection || world.isEmptyBlock(pos.relative(direction)));
        return false;
    }

    private static void generate2(LevelAccessor world, BlockPos pos, RandomSource random, BlockPos rootPos, int size, int layer) {
        GrowingBranchingTrunkBlock branchingTrunkBlock = (GrowingBranchingTrunkBlock)((Object)NSBlocks.ALLUAUDIA.get());
        int i = random.nextInt(1) + 2;
        if (layer == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockPos = pos.above(j + 1);
            if (layer > 0) {
                blockPos = pos.above(j == 0 ? 1 : (int)((double)j / 0.93));
            }
            if (!AlluaudiaFeature.isSurroundedByAir((LevelReader)world, blockPos, Direction.getRandom((RandomSource)random))) {
                return;
            }
            world.setBlock(blockPos, branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos), 2);
            world.setBlock(blockPos.below(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos.below()), 2);
        }
        if (layer < 2) {
            int k = random.nextInt(2) + 4;
            if (layer == 0) {
                ++k;
            }
            for (int l = 0; l < k; ++l) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                int m = random.nextInt(2);
                int n = i - m == 0 ? 1 : i - m;
                BlockPos blockPos2 = pos.above(n).relative(direction, 1);
                if (Math.abs(blockPos2.getX() - rootPos.getX()) >= size || Math.abs(blockPos2.getZ() - rootPos.getZ()) >= size || !world.isEmptyBlock(blockPos2) || !world.isEmptyBlock(blockPos2.below())) continue;
                world.setBlock(blockPos2, branchingTrunkBlock.withHorizontalConnectingProperties((BlockGetter)world, blockPos2), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1).above(), branchingTrunkBlock.withConnectionPropertiesVertical((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1).above()), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1), branchingTrunkBlock.withConnectionPropertiesVertical((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1)), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1).above(2), branchingTrunkBlock.withConnectionPropertiesVertical((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1).above(2)), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1).above(), branchingTrunkBlock.withConnectionPropertiesVertical((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1).above()), 2);
                world.setBlock(blockPos2, branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2), 2);
                world.setBlock(blockPos2.relative(direction.getOpposite()), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getOpposite())), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1)), 2);
                world.setBlock(blockPos2, branchingTrunkBlock.withHorizontalConnectingProperties((BlockGetter)world, blockPos2), 2);
                AlluaudiaFeature.generate2(world, pos.above(n + 1), random, rootPos, size, layer + 1);
                if (random.nextBoolean()) {
                    world.setBlock(blockPos2.relative(direction.getClockWise()).relative(direction).above(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getClockWise()).relative(direction).above()), 2);
                    world.setBlock(blockPos2.relative(direction.getClockWise(), 1).above(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1).above()), 2);
                    continue;
                }
                world.setBlock(blockPos2.relative(direction.getClockWise(), 2).above(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 2).above()), 2);
                world.setBlock(blockPos2.relative(direction.getClockWise(), 1).above(), branchingTrunkBlock.withConnectionProperties((BlockGetter)world, blockPos2.relative(direction.getClockWise(), 1).above()), 2);
            }
        }
    }
}

