/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.world.carver.ReplaceableRavineCarverConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ReplaceableRavineCarver
extends WorldCarver<ReplaceableRavineCarverConfig> {
    public ReplaceableRavineCarver(Codec<ReplaceableRavineCarverConfig> codec) {
        super(codec);
    }

    public boolean isStartChunk(ReplaceableRavineCarverConfig replaceableRavineCarverConfig, RandomSource random) {
        return random.nextFloat() <= replaceableRavineCarverConfig.probability;
    }

    public boolean carve(CarvingContext carverContext, ReplaceableRavineCarverConfig replaceableRavineCarverConfig, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> function, RandomSource random, Aquifer aquiferSampler, ChunkPos chunkPos, CarvingMask carvingMask) {
        int i = (this.getRange() * 2 - 1) * 16;
        double d = chunkPos.getBlockX(random.nextInt(16));
        int j = replaceableRavineCarverConfig.y.sample(random, (WorldGenerationContext)carverContext);
        double e = chunkPos.getBlockZ(random.nextInt(16));
        float f = random.nextFloat() * ((float)Math.PI * 2);
        float g = replaceableRavineCarverConfig.verticalRotation.sample(random);
        double h = replaceableRavineCarverConfig.yScale.sample(random);
        float k = replaceableRavineCarverConfig.shape.thickness.sample(random);
        int l = (int)((float)i * replaceableRavineCarverConfig.shape.distanceFactor.sample(random));
        boolean m = false;
        this.carveEllipsoid(carverContext, replaceableRavineCarverConfig, chunk, function, random.nextLong(), aquiferSampler, d, j, e, k, f, g, 0, l, h, carvingMask);
        return true;
    }

    private void carveEllipsoid(CarvingContext context, ReplaceableRavineCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, long seed, Aquifer aquiferSampler, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask) {
        RandomSource random = RandomSource.create((long)seed);
        float[] fs = this.createHorizontalStretchFactors(context, config, random);
        float f = 0.0f;
        float g = 0.0f;
        for (int i = branchStartIndex; i < branchCount; ++i) {
            double d = 1.5 + (double)(Mth.sin((float)((float)i * (float)Math.PI / (float)branchCount)) * width);
            double e = d * yawPitchRatio;
            d *= (double)config.shape.horizontalRadiusFactor.sample(random);
            e = this.getVerticalScale(config, random, e, branchCount, i);
            float h = Mth.cos((float)pitch);
            float j = Mth.sin((float)pitch);
            x += (double)(Mth.cos((float)yaw) * h);
            y += (double)j;
            z += (double)(Mth.sin((float)yaw) * h);
            pitch *= 0.7f;
            pitch += g * 0.05f;
            yaw += f * 0.05f;
            g *= 0.8f;
            f *= 0.5f;
            g += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) == 0) continue;
            if (!ReplaceableRavineCarver.canReach((ChunkPos)chunk.getPos(), (double)x, (double)z, (int)i, (int)branchCount, (float)width)) {
                return;
            }
            this.carveEllipsoid(context, config, chunk, posToBiome, aquiferSampler, x, y, z, d, e, mask, (contextx, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx) -> this.isPositionExcluded(contextx, fs, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx));
        }
    }

    protected boolean carveBlock(CarvingContext context, ReplaceableRavineCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        BlockState blockState = chunk.getBlockState((BlockPos)pos);
        if (blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.MYCELIUM) || blockState.is((Block)NSBlocks.RED_MOSS_BLOCK.get())) {
            replacedGrassy.setTrue();
        }
        if (!this.canReplaceBlock(config, blockState) && !ReplaceableRavineCarver.isDebugEnabled(config)) {
            return false;
        }
        BlockState blockState2 = this.getState(context, config, (BlockPos)pos, aquiferSampler, chunk);
        if (blockState2 == null) {
            return false;
        }
        chunk.setBlockState((BlockPos)pos, blockState2, false);
        if (aquiferSampler.shouldScheduleFluidUpdate() && !blockState2.getFluidState().isEmpty()) {
            chunk.markPosForPostprocessing((BlockPos)pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.setWithOffset((Vec3i)pos, Direction.DOWN);
            if (chunk.getBlockState((BlockPos)tmp).is(Blocks.DIRT)) {
                context.topMaterial(posToBiome, chunk, (BlockPos)tmp, !blockState2.getFluidState().isEmpty()).ifPresent(state -> {
                    chunk.setBlockState((BlockPos)tmp, state, false);
                    if (!state.getFluidState().isEmpty()) {
                        chunk.markPosForPostprocessing((BlockPos)tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getState(CarvingContext context, ReplaceableRavineCarverConfig config, BlockPos pos, Aquifer sampler, ChunkAccess chunk) {
        if (pos.getY() <= config.lavaLevel.resolveY((WorldGenerationContext)context)) {
            return LAVA.createLegacyBlock();
        }
        BlockState blockState = sampler.computeSubstance((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()), 0.0);
        if (blockState == null) {
            return ReplaceableRavineCarver.isDebugEnabled(config) ? config.debugSettings.getBarrierState() : Blocks.ICE.defaultBlockState();
        }
        return ReplaceableRavineCarver.isDebugEnabled(config) ? ReplaceableRavineCarver.getDebugState(config, blockState) : (chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ()) == pos.getY() ? Blocks.ICE.defaultBlockState() : blockState);
    }

    private static BlockState getDebugState(CarverConfiguration config, BlockState state) {
        if (state.is(Blocks.AIR)) {
            return config.debugSettings.getAirState();
        }
        if (state.is(Blocks.WATER)) {
            BlockState blockState = config.debugSettings.getWaterState();
            return blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : blockState;
        }
        return state.is(Blocks.LAVA) ? config.debugSettings.getLavaState() : state;
    }

    private static boolean isDebugEnabled(CarverConfiguration config) {
        return config.debugSettings.isDebugMode();
    }

    private float[] createHorizontalStretchFactors(CarvingContext context, ReplaceableRavineCarverConfig config, RandomSource random) {
        int i = context.getGenDepth();
        float[] fs = new float[i];
        float f = 1.0f;
        for (int j = 0; j < i; ++j) {
            if (j == 0 || random.nextInt(config.shape.widthSmoothness) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            fs[j] = f * f;
        }
        return fs;
    }

    private double getVerticalScale(ReplaceableRavineCarverConfig config, RandomSource random, double pitch, float branchCount, float branchIndex) {
        float f = 1.0f - Mth.abs((float)(0.5f - branchIndex / branchCount)) * 2.0f;
        float g = config.shape.verticalRadiusDefaultFactor + config.shape.verticalRadiusCenterFactor * f;
        return (double)g * pitch * (double)Mth.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
    }

    private boolean isPositionExcluded(CarvingContext context, float[] horizontalStretchFactors, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        int i = y - context.getMinGenY();
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)horizontalStretchFactors[i - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }
}

