/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.world.carver.ReplaceableCaveCarverConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ReplaceableCaveCarver
extends WorldCarver<ReplaceableCaveCarverConfig> {
    public ReplaceableCaveCarver(Codec<ReplaceableCaveCarverConfig> codec) {
        super(codec);
    }

    public boolean isStartChunk(ReplaceableCaveCarverConfig replaceableCaveCarverConfig, RandomSource random) {
        return random.nextFloat() <= replaceableCaveCarverConfig.probability;
    }

    public boolean carve(CarvingContext carverContext, ReplaceableCaveCarverConfig replaceableCaveCarverConfig, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> function, RandomSource random, Aquifer aquiferSampler, ChunkPos chunkPos, CarvingMask carvingMask) {
        int i = SectionPos.sectionToBlockCoord((int)(this.getRange() * 2 - 1));
        int j = random.nextInt(random.nextInt(random.nextInt(this.getMaxCaveCount()) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            float o;
            double d = chunkPos.getBlockX(random.nextInt(16));
            double e = replaceableCaveCarverConfig.y.sample(random, (WorldGenerationContext)carverContext);
            double f = chunkPos.getBlockZ(random.nextInt(16));
            double g = replaceableCaveCarverConfig.horizontalRadiusMultiplier.sample(random);
            double h = replaceableCaveCarverConfig.verticalRadiusMultiplier.sample(random);
            double l = replaceableCaveCarverConfig.floorLevel.sample(random);
            WorldCarver.CarveSkipChecker skipPredicate = (contextx, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y) -> ReplaceableCaveCarver.isPositionExcluded(scaledRelativeX, scaledRelativeY, scaledRelativeZ, l);
            int m = 1;
            if (random.nextInt(4) == 0) {
                double n = replaceableCaveCarverConfig.yScale.sample(random);
                o = 1.0f + random.nextFloat() * 6.0f;
                this.carveCave(carverContext, replaceableCaveCarverConfig, chunk, function, aquiferSampler, d, e, f, o, n, carvingMask, skipPredicate);
                m += random.nextInt(4);
            }
            for (int p = 0; p < m; ++p) {
                float q = random.nextFloat() * ((float)Math.PI * 2);
                o = (random.nextFloat() - 0.5f) / 4.0f;
                float r = this.getTunnelSystemWidth(random);
                int s = i - random.nextInt(i / 4);
                this.carveTunnels(carverContext, replaceableCaveCarverConfig, chunk, function, random.nextLong(), aquiferSampler, d, e, f, g, h, r, q, o, 0, s, this.getTunnelSystemHeightWidthRatio(), carvingMask, skipPredicate);
            }
        }
        return true;
    }

    protected boolean carveBlock(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        BlockState blockState = chunk.getBlockState((BlockPos)pos);
        if (blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.MYCELIUM) || blockState.is((Block)NSBlocks.RED_MOSS_BLOCK.get())) {
            replacedGrassy.setTrue();
        }
        if (!this.canReplaceBlock(config, blockState) && !ReplaceableCaveCarver.isDebugEnabled(config)) {
            return false;
        }
        BlockState blockState2 = this.getState(context, config, (BlockPos)pos, aquiferSampler, chunk);
        if (blockState2 == null) {
            return false;
        }
        chunk.setBlockState((BlockPos)pos, blockState2, false);
        if (aquiferSampler.shouldScheduleFluidUpdate() && !blockState2.getFluidState().isEmpty()) {
            chunk.markPosForPostprocessing((BlockPos)pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.setWithOffset((Vec3i)pos, Direction.DOWN);
            if (chunk.getBlockState((BlockPos)tmp).is(Blocks.DIRT)) {
                context.topMaterial(posToBiome, chunk, (BlockPos)tmp, !blockState2.getFluidState().isEmpty()).ifPresent(state -> {
                    chunk.setBlockState((BlockPos)tmp, state, false);
                    if (!state.getFluidState().isEmpty()) {
                        chunk.markPosForPostprocessing((BlockPos)tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getState(CarvingContext context, ReplaceableCaveCarverConfig config, BlockPos pos, Aquifer sampler, ChunkAccess chunk) {
        if (pos.getY() <= config.lavaLevel.resolveY((WorldGenerationContext)context)) {
            return LAVA.createLegacyBlock();
        }
        BlockState blockState = sampler.computeSubstance((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()), 0.0);
        if (blockState == null) {
            return ReplaceableCaveCarver.isDebugEnabled(config) ? config.debugSettings.getBarrierState() : Blocks.ICE.defaultBlockState();
        }
        return ReplaceableCaveCarver.isDebugEnabled(config) ? ReplaceableCaveCarver.getDebugState(config, blockState) : (chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ()) == pos.getY() ? Blocks.ICE.defaultBlockState() : blockState);
    }

    private static BlockState getDebugState(CarverConfiguration config, BlockState state) {
        if (state.is(Blocks.AIR)) {
            return config.debugSettings.getAirState();
        }
        if (state.is(Blocks.WATER)) {
            BlockState blockState = config.debugSettings.getWaterState();
            return blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : blockState;
        }
        return state.is(Blocks.LAVA) ? config.debugSettings.getLavaState() : state;
    }

    private static boolean isDebugEnabled(CarverConfiguration config) {
        return config.debugSettings.isDebugMode();
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected float getTunnelSystemWidth(RandomSource random) {
        float f = random.nextFloat() * 2.0f + random.nextFloat();
        if (random.nextInt(10) == 0) {
            f *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getTunnelSystemHeightWidthRatio() {
        return 1.0;
    }

    protected void carveCave(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, Aquifer aquiferSampler, double d, double e, double f, float g, double h, CarvingMask mask, WorldCarver.CarveSkipChecker skipPredicate) {
        double i = 1.5 + (double)(Mth.sin((float)1.5707964f) * g);
        double j = i * h;
        this.carveEllipsoid(context, config, chunk, posToBiome, aquiferSampler, d + 1.0, e, f, i, j, mask, skipPredicate);
    }

    protected void carveTunnels(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, long seed, Aquifer aquiferSampler, double x, double y, double z, double horizontalScale, double verticalScale, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask, WorldCarver.CarveSkipChecker skipPredicate) {
        RandomSource random = RandomSource.create((long)seed);
        int i = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = random.nextInt(6) == 0;
        float f = 0.0f;
        float g = 0.0f;
        for (int j = branchStartIndex; j < branchCount; ++j) {
            double d = 1.5 + (double)(Mth.sin((float)((float)Math.PI * (float)j / (float)branchCount)) * width);
            double e = d * yawPitchRatio;
            float h = Mth.cos((float)pitch);
            x += (double)(Mth.cos((float)yaw) * h);
            y += (double)Mth.sin((float)pitch);
            z += (double)(Mth.sin((float)yaw) * h);
            pitch *= bl ? 0.92f : 0.7f;
            pitch += g * 0.1f;
            yaw += f * 0.1f;
            g *= 0.9f;
            f *= 0.75f;
            g += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && width > 1.0f) {
                this.carveTunnels(context, config, chunk, posToBiome, random.nextLong(), aquiferSampler, x, y, z, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, skipPredicate);
                this.carveTunnels(context, config, chunk, posToBiome, random.nextLong(), aquiferSampler, x, y, z, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, skipPredicate);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!ReplaceableCaveCarver.canReach((ChunkPos)chunk.getPos(), (double)x, (double)z, (int)j, (int)branchCount, (float)width)) {
                return;
            }
            this.carveEllipsoid(context, config, chunk, posToBiome, aquiferSampler, x, y, z, d * horizontalScale, e * verticalScale, mask, skipPredicate);
        }
    }

    private static boolean isPositionExcluded(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, double floorY) {
        if (scaledRelativeY <= floorY) {
            return true;
        }
        return scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }
}

