/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.util;

import net.hibiscus.naturespirit.blocks.CheeseCauldronBlock;
import net.hibiscus.naturespirit.blocks.MilkCauldronBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="natures_spirit")
public class NSEvents {
    @SubscribeEvent
    public static void interactEvent(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getLevel().getBlockState(blockPos);
        Level world = event.getLevel();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (blockState.is(BlockTags.CAULDRONS) && event.getItemStack().is(Items.MILK_BUCKET) && !blockState.is((Block)NSBlocks.MILK_CAULDRON.get())) {
            event.setUseItem(TriState.FALSE);
            world.playSound(player, blockPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, event.getItemStack());
            }
            world.setBlock(blockPos, ((MilkCauldronBlock)((Object)NSBlocks.MILK_CAULDRON.get())).defaultBlockState(), 11);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)((MilkCauldronBlock)((Object)NSBlocks.MILK_CAULDRON.get())).defaultBlockState()));
            if (!player.isCreative() && !player.isSpectator()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
            event.setCanceled(true);
        }
        if (blockState.is(BlockTags.CAULDRONS) && event.getItemStack().is((Item)NSBlocks.CHEESE_BUCKET.get()) && !blockState.is((Block)NSBlocks.CHEESE_CAULDRON.get())) {
            world.playSound(player, blockPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, event.getItemStack());
            }
            world.setBlock(blockPos, ((CheeseCauldronBlock)((Object)NSBlocks.CHEESE_CAULDRON.get())).defaultBlockState(), 11);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)((CheeseCauldronBlock)((Object)NSBlocks.CHEESE_CAULDRON.get())).defaultBlockState()));
            if (!player.isCreative() && !player.isSpectator()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
            event.setCanceled(true);
        }
    }
}

