/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class TerraLaetaParameters
extends OverworldBiomeBuilder {
    private final Climate.Parameter defaultParameter = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatureParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidityParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosionParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter frozenTemperature;
    private final Climate.Parameter erodedRiverTemperatureParameters;
    private final Climate.Parameter riverTemperatureParameters;
    private final Climate.Parameter mushroomFieldsContinentalness;
    private final Climate.Parameter deepOceanContinentalness;
    private final Climate.Parameter oceanContinentalness;
    private final Climate.Parameter coastContinentalness;
    private final Climate.Parameter riverContinentalness;
    private final Climate.Parameter nearInlandContinentalness;
    private final Climate.Parameter midInlandContinentalness;
    private final Climate.Parameter farInlandContinentalness;
    private final ResourceKey<Biome>[][] oceanBiomes;
    private final ResourceKey<Biome>[][] commonBiomes;
    private final ResourceKey<Biome>[][] uncommonBiomes;
    private final ResourceKey<Biome>[][] nearMountainBiomes;
    private final ResourceKey<Biome>[][] specialNearMountainBiomes;
    private final ResourceKey<Biome>[][] windsweptBiomes;
    ResourceKey<Biome> commonBiomeDesertHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.DESERT;
    ResourceKey<Biome> commonBiomeDesertHot2 = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.DESERT;
    ResourceKey<Biome> nearBiomeBadlandsHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.BADLANDS;
    ResourceKey<Biome> nearBiomeWoodedBadlandsHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.WOODED_BADLANDS;
    ResourceKey<Biome> specialBiomeErodedBadlandsHot = NSConfig.hasXericPlains ? null : Biomes.ERODED_BADLANDS;
    ResourceKey<Biome> commonBiomeSavannaWarm = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.SAVANNA;
    ResourceKey<Biome> uncommonBiomePlainsWarm = NSConfig.hasCypressFields ? null : Biomes.PLAINS;
    ResourceKey<Biome> commonBiomeForestWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.FOREST;
    ResourceKey<Biome> commonBiomeJungleWarm;
    ResourceKey<Biome> commonBiomeJungleWarm2;
    ResourceKey<Biome> nearBiomeSavannaPlateauWarm;
    ResourceKey<Biome> nearBiomeForestWarm;
    ResourceKey<Biome> nearBiomeForestWarm2;
    ResourceKey<Biome> nearBiomeJungleWarm;
    ResourceKey<Biome> uncommonSparseJungleWarm;
    ResourceKey<Biome> uncommonBambooJungleWarm;
    ResourceKey<Biome> specialBiomeCedar;
    ResourceKey<Biome> specialBiomeNull;
    ResourceKey<Biome> commonBiomePlainsCold;
    ResourceKey<Biome> uncommonBiomePlainsCold;
    ResourceKey<Biome> commonBiomeForestCold;
    ResourceKey<Biome> specialBiomeMeadowCold;
    ResourceKey<Biome> commonBiomeSnowyPlainsFrozen;
    ResourceKey<Biome> nearBiomeMeadowCold;
    ResourceKey<Biome> nearBiomeForestCold;
    ResourceKey<Biome> commonBiomeTaiga;
    ResourceKey<Biome> commonBiomeOldTaiga;
    ResourceKey<Biome> uncommonBiomeOldTaiga;
    ResourceKey<Biome> uncommonBiomeTaiga;
    ResourceKey<Biome> specialNearBiomeCherryCold;
    ResourceKey<Biome> commonBiomeSnowyTaigaFrozen;
    ResourceKey<Biome> uncommonBiomeSnowyTaigaFrozen;
    ResourceKey<Biome> commonBiomeTaigaFrozen;
    ResourceKey[] windsweptFrozen;
    ResourceKey[] windsweptCold;

    public TerraLaetaParameters() {
        ResourceKey[] resourceKeyArray;
        ResourceKey[] resourceKeyArray2;
        ResourceKey resourceKey = this.commonBiomeJungleWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.JUNGLE;
        this.commonBiomeJungleWarm2 = NSConfig.hasLavenderFields ? NSBiomes.LAVENDER_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.JUNGLE);
        this.nearBiomeSavannaPlateauWarm = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.SAVANNA_PLATEAU;
        this.nearBiomeForestWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.FOREST;
        ResourceKey resourceKey2 = this.nearBiomeForestWarm2 = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.FOREST;
        this.nearBiomeJungleWarm = NSConfig.hasLavenderFields ? NSBiomes.LAVENDER_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.JUNGLE);
        ResourceKey resourceKey3 = this.uncommonSparseJungleWarm = NSConfig.hasCypressFields ? null : Biomes.SPARSE_JUNGLE;
        this.uncommonBambooJungleWarm = NSConfig.hasCarnationFields ? NSBiomes.CARNATION_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.BAMBOO_JUNGLE);
        this.specialBiomeCedar = NSConfig.hasCedarThicket ? NSBiomes.CEDAR_THICKET : null;
        this.specialBiomeNull = NSConfig.hasCypressFields ? NSBiomes.CARNATION_FIELDS : null;
        this.commonBiomePlainsCold = NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.PLAINS;
        this.uncommonBiomePlainsCold = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : null;
        this.commonBiomeForestCold = NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.FOREST;
        this.specialBiomeMeadowCold = NSConfig.hasAlpineClearings ? null : Biomes.MEADOW;
        this.commonBiomeSnowyPlainsFrozen = NSConfig.hasTundra && (NSConfig.hasAlpineHighlands || NSConfig.hasAlpineClearings) ? NSBiomes.TUNDRA : Biomes.SNOWY_PLAINS;
        ResourceKey resourceKey4 = this.nearBiomeMeadowCold = NSConfig.hasAlpineHighlands ? NSBiomes.ALPINE_HIGHLANDS : Biomes.MEADOW;
        this.nearBiomeForestCold = NSConfig.hasAlpineHighlands ? NSBiomes.ALPINE_HIGHLANDS : (NSConfig.hasAlpineClearings ? Biomes.MEADOW : Biomes.FOREST);
        this.commonBiomeTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.TAIGA;
        this.commonBiomeOldTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.OLD_GROWTH_SPRUCE_TAIGA;
        this.uncommonBiomeOldTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.OLD_GROWTH_PINE_TAIGA;
        ResourceKey resourceKey5 = this.uncommonBiomeTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.OLD_GROWTH_PINE_TAIGA;
        this.specialNearBiomeCherryCold = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : (NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.CHERRY_GROVE);
        this.commonBiomeSnowyTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.SNOWY_TAIGA;
        this.uncommonBiomeSnowyTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.SNOWY_TAIGA;
        ResourceKey resourceKey6 = this.commonBiomeTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.TAIGA;
        if (NSConfig.hasTundra && NSConfig.hasAlpineClearings) {
            ResourceKey[] resourceKeyArray3 = new ResourceKey[5];
            resourceKeyArray3[0] = NSBiomes.TUNDRA;
            resourceKeyArray3[1] = NSBiomes.TUNDRA;
            resourceKeyArray3[2] = NSBiomes.TUNDRA;
            resourceKeyArray3[3] = NSBiomes.TUNDRA;
            resourceKeyArray2 = resourceKeyArray3;
            resourceKeyArray3[4] = NSBiomes.TUNDRA;
        } else {
            ResourceKey[] resourceKeyArray4 = new ResourceKey[5];
            resourceKeyArray4[0] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray4[1] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray4[2] = Biomes.WINDSWEPT_HILLS;
            resourceKeyArray4[3] = Biomes.WINDSWEPT_FOREST;
            resourceKeyArray2 = resourceKeyArray4;
            resourceKeyArray4[4] = Biomes.WINDSWEPT_FOREST;
        }
        this.windsweptFrozen = resourceKeyArray2;
        if (NSConfig.hasAlpineHighlands) {
            ResourceKey[] resourceKeyArray5 = new ResourceKey[5];
            resourceKeyArray5[0] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[1] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[2] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[3] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray = resourceKeyArray5;
            resourceKeyArray5[4] = NSBiomes.ALPINE_HIGHLANDS;
        } else {
            ResourceKey[] resourceKeyArray6 = new ResourceKey[5];
            resourceKeyArray6[0] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray6[1] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray6[2] = Biomes.WINDSWEPT_HILLS;
            resourceKeyArray6[3] = Biomes.WINDSWEPT_FOREST;
            resourceKeyArray = resourceKeyArray6;
            resourceKeyArray6[4] = Biomes.WINDSWEPT_FOREST;
        }
        this.windsweptCold = resourceKeyArray;
        this.frozenTemperature = this.temperatureParameters[0];
        this.erodedRiverTemperatureParameters = Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[2]);
        this.riverTemperatureParameters = Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[3], (Climate.Parameter)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
        this.oceanBiomes = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
        this.commonBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeTaigaFrozen}, {this.commonBiomePlainsCold, this.commonBiomePlainsCold, this.commonBiomeForestCold, this.commonBiomeTaiga, this.commonBiomeOldTaiga}, {Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {this.commonBiomeSavannaWarm, this.commonBiomeSavannaWarm, this.commonBiomeForestWarm, this.commonBiomeJungleWarm, this.commonBiomeJungleWarm2}, {this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot2, this.commonBiomeDesertHot2}};
        this.uncommonBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, this.uncommonBiomeSnowyTaigaFrozen, null, null}, {this.uncommonBiomePlainsCold, null, null, this.uncommonBiomeTaiga, this.uncommonBiomeOldTaiga}, {null, null, null, null, null}, {this.specialBiomeCedar, null, this.uncommonBiomePlainsWarm, this.uncommonSparseJungleWarm, this.uncommonBambooJungleWarm}, {null, null, null, null, null}};
        this.nearMountainBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeSnowyTaigaFrozen}, {this.nearBiomeMeadowCold, this.nearBiomeMeadowCold, this.nearBiomeForestCold, this.commonBiomeTaiga, this.commonBiomeOldTaiga}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {this.nearBiomeSavannaPlateauWarm, this.nearBiomeSavannaPlateauWarm, this.nearBiomeForestWarm, this.nearBiomeForestWarm2, this.nearBiomeJungleWarm}, {this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeWoodedBadlandsHot, this.nearBiomeWoodedBadlandsHot}};
        this.specialNearMountainBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {this.specialNearBiomeCherryCold, null, this.specialBiomeMeadowCold, null, this.uncommonBiomeOldTaiga}, {Biomes.CHERRY_GROVE, Biomes.CHERRY_GROVE, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {this.specialBiomeCedar, null, null, null, this.specialBiomeNull}, {this.specialBiomeErodedBadlandsHot, this.specialBiomeErodedBadlandsHot, null, null, null}};
        this.windsweptBiomes = new ResourceKey[][]{this.windsweptFrozen, this.windsweptCold, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addOffCoastBiomes(parameters);
        this.addInlandBiomes(parameters);
        this.addUndergroundBiomes(parameters);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addMidSlice(parameters, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(parameters, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(parameters, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(parameters, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getXericPlainsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey5);
                ResourceKey<Biome> registryKey7 = this.pickPeakBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey10 = this.getShoreCliffBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey11 = this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[0], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[1], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey11 : registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getXericPlainsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey7 = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.pickPeakBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey11 = this.getShoreCliffBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey11 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey7 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey8 = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey9 = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey registryKey12 = this.getShoreCliffBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)(NSConfig.hasWhiteCliffs ? registryKey12 : Biomes.STONY_SHORE));
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey);
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                } else {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                } else {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey5 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey6 = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.getShoreCliffBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey8 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
                if (i != 0) continue;
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.FROZEN_RIVER));
        this.addSurfaceBiome(parameters, this.riverTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER));
        this.addSurfaceBiome(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER));
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.riverTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.riverTemperatureParameters, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.riverTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = NSConfig.hasXericPlains ? this.pickMiddleBiome(i, j, weirdness) : this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
            }
        }
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        ResourceKey<Biome> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidity, Climate.Parameter weirdness) {
        if (humidity < 2) {
            return weirdness.max() < 0L ? Biomes.BADLANDS : Biomes.ERODED_BADLANDS;
        }
        return humidity < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? this.pickBadlandsBiome(humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> getWetlandType(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            return this.pickMiddleBiome(temperature, humidity, weirdness);
        }
        if ((humidity <= 3 || temperature >= 3) && NSConfig.hasMarsh) {
            return NSBiomes.MARSH;
        }
        return Biomes.SWAMP;
    }

    private ResourceKey<Biome> getXericPlainsOrRegularBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? (NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : this.pickBadlandsBiome(humidity, weirdness)) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && humidity < 4 && weirdness.max() >= 0L ? (NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.WINDSWEPT_SAVANNA) : biomeKey;
    }

    private ResourceKey<Biome> getBiomeOrChalkCliffs(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && temperature < 4 && humidity < 4 && humidity > 0 && weirdness.max() >= 0L ? NSBiomes.WHITE_CLIFFS : this.maybePickWindsweptSavannaBiome(temperature, humidity, weirdness, biomeKey);
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = weirdness.max() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature, humidity);
        return this.getBiomeOrChalkCliffs(temperature, humidity, weirdness, registryKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature, int humidity) {
        if (temperature == 0) {
            return Biomes.SNOWY_BEACH;
        }
        if (temperature == 3 && humidity > 2 && NSConfig.hasTropicalShores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? (NSConfig.hasXericPlains ? NSBiomes.DRYLANDS : Biomes.DESERT) : Biomes.BEACH;
    }

    private ResourceKey<Biome> getShoreCliffBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature < 4 && temperature > 0 ? NSBiomes.WHITE_CLIFFS : Biomes.STONY_SHORE;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey;
        if (weirdness.max() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature <= 1 && (NSConfig.hasAlpineHighlands || NSConfig.hasAlpineClearings) && humidity <= 2 && weirdness.max() >= 0L) {
            return Biomes.STONY_PEAKS;
        }
        if (temperature <= 2) {
            return weirdness.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        return temperature == 3 ? (NSConfig.hasRedPeaks && humidity < 3 ? NSBiomes.RED_PEAKS : Biomes.STONY_PEAKS) : (NSConfig.hasRedPeaks ? NSBiomes.RED_PEAKS : this.pickBadlandsBiome(humidity, weirdness));
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 4) {
            return NSConfig.hasDustySlopes ? NSBiomes.DUSTY_SLOPES : this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        if (temperature >= 3) {
            return this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        if (NSConfig.hasTundra && (NSConfig.hasAlpineClearings || NSConfig.hasAlpineHighlands)) {
            return humidity <= 2 && temperature <= 1 && weirdness.max() >= 0L ? NSBiomes.TUNDRA : Biomes.GROVE;
        }
        return humidity <= 1 ? Biomes.SNOWY_SLOPES : Biomes.GROVE;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : registryKey;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

