/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class TerraFlavaParameters
extends OverworldBiomeBuilder {
    private final Climate.Parameter defaultParameter = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatureParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidityParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosionParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter frozenTemperature;
    private final Climate.Parameter nonFrozenTemperatureParameters;
    private final Climate.Parameter mushroomFieldsContinentalness;
    private final Climate.Parameter deepOceanContinentalness;
    private final Climate.Parameter oceanContinentalness;
    private final Climate.Parameter coastContinentalness;
    private final Climate.Parameter riverContinentalness;
    private final Climate.Parameter nearInlandContinentalness;
    private final Climate.Parameter midInlandContinentalness;
    private final Climate.Parameter farInlandContinentalness;
    private final ResourceKey<Biome>[][] oceanBiomes;
    private final ResourceKey<Biome>[][] commonBiomes;
    private final ResourceKey<Biome>[][] uncommonBiomes;
    private final ResourceKey<Biome>[][] nearMountainBiomes;
    private final ResourceKey<Biome>[][] specialNearMountainBiomes;
    private final ResourceKey<Biome>[][] windsweptBiomes;
    ResourceKey<Biome> commonBiomePlainsCold = NSConfig.hasGoldenWilds ? NSBiomes.GOLDEN_WILDS : Biomes.PLAINS;
    ResourceKey<Biome> mountainBiomeMeadowCold = NSConfig.hasGoldenWilds ? NSBiomes.GOLDEN_WILDS : Biomes.MEADOW;
    ResourceKey<Biome> mountainBiomeForestCold;
    ResourceKey<Biome> mountainBiomeMeadowCold2;
    ResourceKey<Biome> uncommonBiomeCold;
    ResourceKey<Biome> commonBiomeForestCold;
    ResourceKey<Biome> commonBiomeTaigaCold;
    ResourceKey<Biome> commonBiomeOldSpruceCold;
    ResourceKey<Biome> uncommonBiomeOldPineCold;
    ResourceKey<Biome> commonBiomeDesertHot;
    ResourceKey<Biome> commonBiomeDesertHot2;
    ResourceKey<Biome> commonBiomeSavannaWarm;
    ResourceKey<Biome> commonBiomeForestWarm;
    ResourceKey<Biome> nearBiomeSavannaPlateauWarm;
    ResourceKey<Biome> nearBiomeBadlandsHot;
    ResourceKey<Biome> nearBiomeWoodedBadlandsHot;
    ResourceKey<Biome> nearBiomeBadlandsHot2;
    ResourceKey<Biome> specialBiomeErodedBadlandsHot;

    public TerraFlavaParameters() {
        ResourceKey resourceKey = this.mountainBiomeForestCold = NSConfig.hasGoldenWilds ? NSBiomes.GOLDEN_WILDS : Biomes.FOREST;
        this.mountainBiomeMeadowCold2 = NSConfig.hasMarigoldMeadows ? NSBiomes.MARIGOLD_MEADOWS : (NSConfig.hasGoldenWilds ? NSBiomes.GOLDEN_WILDS : Biomes.MEADOW);
        this.uncommonBiomeCold = NSConfig.hasMarigoldMeadows ? NSBiomes.MARIGOLD_MEADOWS : null;
        this.commonBiomeForestCold = NSConfig.hasMapleWoodlands ? NSBiomes.MAPLE_WOODLANDS : Biomes.FOREST;
        this.commonBiomeTaigaCold = NSConfig.hasAspenForest ? NSBiomes.ASPEN_FOREST : Biomes.TAIGA;
        this.commonBiomeOldSpruceCold = NSConfig.hasAspenForest ? NSBiomes.ASPEN_FOREST : Biomes.OLD_GROWTH_SPRUCE_TAIGA;
        this.uncommonBiomeOldPineCold = NSConfig.hasAspenForest ? null : Biomes.OLD_GROWTH_PINE_TAIGA;
        this.commonBiomeDesertHot = NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.DESERT;
        this.commonBiomeDesertHot2 = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.DESERT;
        this.commonBiomeSavannaWarm = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.SAVANNA;
        this.commonBiomeForestWarm = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.FOREST;
        this.nearBiomeSavannaPlateauWarm = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.SAVANNA_PLATEAU;
        this.nearBiomeBadlandsHot = NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.BADLANDS;
        this.nearBiomeWoodedBadlandsHot = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.WOODED_BADLANDS;
        this.nearBiomeBadlandsHot2 = NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : Biomes.BADLANDS;
        this.specialBiomeErodedBadlandsHot = NSConfig.hasDrylands ? null : Biomes.ERODED_BADLANDS;
        this.frozenTemperature = this.temperatureParameters[0];
        this.nonFrozenTemperatureParameters = Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
        this.oceanBiomes = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
        this.commonBiomes = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.TAIGA}, {this.commonBiomePlainsCold, this.commonBiomePlainsCold, this.commonBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {this.commonBiomeSavannaWarm, this.commonBiomeSavannaWarm, this.commonBiomeForestWarm, Biomes.JUNGLE, Biomes.JUNGLE}, {this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot2}};
        this.uncommonBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, Biomes.SNOWY_TAIGA, null, null}, {this.uncommonBiomeCold, null, null, null, this.uncommonBiomeOldPineCold}, {Biomes.SUNFLOWER_PLAINS, null, null, Biomes.OLD_GROWTH_BIRCH_FOREST, null}, {null, null, null, Biomes.SPARSE_JUNGLE, null}, {null, null, null, null, null}};
        this.nearMountainBiomes = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.SNOWY_TAIGA}, {this.mountainBiomeMeadowCold2, this.mountainBiomeMeadowCold, this.mountainBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {this.nearBiomeSavannaPlateauWarm, this.nearBiomeSavannaPlateauWarm, this.commonBiomeForestWarm, Biomes.FOREST, Biomes.JUNGLE}, {this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot2, this.nearBiomeWoodedBadlandsHot, this.nearBiomeWoodedBadlandsHot}};
        this.specialNearMountainBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {null, this.uncommonBiomeCold, null, null, this.uncommonBiomeOldPineCold}, {Biomes.CHERRY_GROVE, Biomes.CHERRY_GROVE, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {null, null, null, null, null}, {this.specialBiomeErodedBadlandsHot, this.specialBiomeErodedBadlandsHot, null, null, null}};
        this.windsweptBiomes = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addOffCoastBiomes(parameters);
        this.addInlandBiomes(parameters);
        this.addUndergroundBiomes(parameters);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addMidSlice(parameters, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(parameters, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(parameters, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(parameters, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getWoodedDrylandsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey5);
                ResourceKey<Biome> registryKey7 = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasDrylands ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getWoodedDrylandsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey7 = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[2]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[3], (Climate.Parameter)this.temperatureParameters[4]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey7 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey8 = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey9 = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasDrylands ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NSConfig.hasDrylands ? registryKey : registryKey2);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                } else {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                } else {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[2]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[3], (Climate.Parameter)this.temperatureParameters[4]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey5 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey6 = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, NSConfig.hasDrylands ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasDrylands ? registryKey : registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[3], (Climate.Parameter)this.erosionParameters[4]), weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
                if (i != 0) continue;
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.FROZEN_RIVER));
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER));
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[2]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.addSurfaceBiome(parameters, Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[3], (Climate.Parameter)this.temperatureParameters[4]), this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = NSConfig.hasDrylands ? this.pickMiddleBiome(i, j, weirdness) : this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
            }
        }
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        ResourceKey<Biome> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && humidity < 4 && weirdness.max() >= 0L ? Biomes.WINDSWEPT_SAVANNA : biomeKey;
    }

    private ResourceKey<Biome> getWoodedDrylandsOrRegularBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 && NSConfig.hasWoodedDrylands ? NSBiomes.WOODED_DRYLANDS : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidity, Climate.Parameter weirdness) {
        if (humidity < 2) {
            return weirdness.max() < 0L ? Biomes.BADLANDS : Biomes.ERODED_BADLANDS;
        }
        return humidity < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? this.pickBadlandsBiome(humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = weirdness.max() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature, humidity);
        return this.maybePickWindsweptSavannaBiome(temperature, humidity, weirdness, registryKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature, int humidity) {
        if (temperature == 0) {
            return Biomes.SNOWY_BEACH;
        }
        if (temperature == 3 && NSConfig.hasTropicalShores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? (NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.DESERT) : Biomes.BEACH;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey;
        if (weirdness.max() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature <= 2) {
            return weirdness.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        return Biomes.STONY_PEAKS;
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature >= 3) {
            return this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        return humidity <= 1 ? Biomes.SNOWY_SLOPES : Biomes.GROVE;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : registryKey;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

