/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class TerraFeraxParameters
extends OverworldBiomeBuilder {
    private final Climate.Parameter defaultParameter = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatureParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidityParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosionParameters = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter frozenTemperature;
    private final Climate.Parameter nonFrozenTemperatureParameters;
    private final Climate.Parameter mushroomFieldsContinentalness;
    private final Climate.Parameter deepOceanContinentalness;
    private final Climate.Parameter oceanContinentalness;
    private final Climate.Parameter coastContinentalness;
    private final Climate.Parameter riverContinentalness;
    private final Climate.Parameter nearInlandContinentalness;
    private final Climate.Parameter midInlandContinentalness;
    private final Climate.Parameter farInlandContinentalness;
    private final ResourceKey<Biome>[][] oceanBiomes;
    private final ResourceKey<Biome>[][] commonBiomes;
    private final ResourceKey<Biome>[][] uncommonBiomes;
    private final ResourceKey<Biome>[][] nearMountainBiomes;
    private final ResourceKey<Biome>[][] specialNearMountainBiomes;
    private final ResourceKey<Biome>[][] windsweptBiomes;
    ResourceKey<Biome> commonBiomeSnowyPlainsFrozen = NSConfig.hasTundra ? NSBiomes.TUNDRA : Biomes.SNOWY_PLAINS;
    ResourceKey<Biome> commonBiomeSnowyTaigaFrozen = NSConfig.hasSnowyFirForest ? NSBiomes.SNOWY_FIR_FOREST : Biomes.SNOWY_TAIGA;
    ResourceKey<Biome> commonBiomePlainsCold = NSConfig.hasPrairie ? NSBiomes.PRAIRIE : Biomes.PLAINS;
    ResourceKey<Biome> commonBiomeForestCold = NSConfig.hasPrairie ? NSBiomes.PRAIRIE : Biomes.FOREST;
    ResourceKey<Biome> mountainBiomeMeadowCold = NSConfig.hasPrairie ? NSBiomes.PRAIRIE : Biomes.MEADOW;
    ResourceKey<Biome> commonBiomeTaigaCold = NSConfig.hasFirForest ? NSBiomes.FIR_FOREST : Biomes.TAIGA;
    ResourceKey<Biome> commonBiomeOldSpruceCold = NSConfig.hasRedwoodForest ? NSBiomes.REDWOOD_FOREST : Biomes.OLD_GROWTH_SPRUCE_TAIGA;
    ResourceKey<Biome> uncommonBiomeOldPineCold = NSConfig.hasRedwoodForest ? null : Biomes.OLD_GROWTH_PINE_TAIGA;
    ResourceKey<Biome> commonBiomeSnowyTaigaFrozen2 = NSConfig.hasSnowyRedwoodForest ? NSBiomes.SNOWY_REDWOOD_FOREST : Biomes.SNOWY_TAIGA;
    ResourceKey<Biome> specialBiomeCherryGrove = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : Biomes.CHERRY_GROVE;
    ResourceKey<Biome> commonBiomeDesert = NSConfig.hasLivelyDunes ? NSBiomes.LIVELY_DUNES : Biomes.DESERT;
    ResourceKey<Biome> commonBiomeDesert2 = NSConfig.hasBloomingDunes ? NSBiomes.BLOOMING_DUNES : Biomes.DESERT;
    ResourceKey<Biome> commonBiomeDesert3 = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.DESERT;
    ResourceKey<Biome> uncommonBiomePlainsWarm = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.PLAINS;
    ResourceKey<Biome> uncommonBiomeDesert = NSConfig.hasBloomingDunes ? NSBiomes.BLOOMING_DUNES : null;
    ResourceKey<Biome> nearBiomeBadlands = NSConfig.hasStratifiedDesert ? NSBiomes.STRATIFIED_DESERT : Biomes.BADLANDS;
    ResourceKey<Biome> nearBiomeWoodedBadlands = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.WOODED_BADLANDS;
    ResourceKey<Biome> specialBiomeErodedBadlands = NSConfig.hasStratifiedDesert ? null : Biomes.ERODED_BADLANDS;
    ResourceKey<Biome> specialBiomeWoodedBadlands = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : null;
    ResourceKey<Biome> uncommonBiomePlainsCold = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : null;
    ResourceKey<Biome> commonBiomeFlowerForestTemperate = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.FLOWER_FOREST;
    ResourceKey<Biome> commonBiomeSavannaWarm = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.SAVANNA;
    ResourceKey<Biome> commonBiomePlainsTemperate = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.PLAINS;
    ResourceKey<Biome> nearBiomeMeadowTemperate = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.MEADOW;
    ResourceKey<Biome> nearBiomeSavannaPlateauTemperate = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.SAVANNA_PLATEAU;
    ResourceKey<Biome> specialBiomeCherryGroveTemperate = NSConfig.hasOakSavanna ? NSBiomes.OAK_SAVANNA : Biomes.CHERRY_GROVE;
    ResourceKey<Biome> windsweptBiomeWindsweptHillsTemperate = NSConfig.hasOakSavanna ? null : Biomes.WINDSWEPT_HILLS;
    ResourceKey<Biome> commonBiomeJungleWarm = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.JUNGLE;
    ResourceKey<Biome> nearBiomeForestWarm = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.FOREST;
    ResourceKey<Biome> uncommonBiomeSparseJungleWarm = NSConfig.hasChaparral ? NSBiomes.CHAPARRAL : Biomes.SPARSE_JUNGLE;
    ResourceKey<Biome> uncommonBiomeBambooJungleWarm;
    ResourceKey[] windsweptFrozen;
    ResourceKey[] windsweptCold;

    public TerraFeraxParameters() {
        ResourceKey[] resourceKeyArray;
        ResourceKey[] resourceKeyArray2;
        ResourceKey resourceKey = this.uncommonBiomeBambooJungleWarm = NSConfig.hasChaparral ? null : Biomes.BAMBOO_JUNGLE;
        if (NSConfig.hasTundra) {
            ResourceKey[] resourceKeyArray3 = new ResourceKey[5];
            resourceKeyArray3[0] = NSBiomes.TUNDRA;
            resourceKeyArray3[1] = NSBiomes.TUNDRA;
            resourceKeyArray3[2] = NSBiomes.TUNDRA;
            resourceKeyArray3[3] = NSBiomes.TUNDRA;
            resourceKeyArray2 = resourceKeyArray3;
            resourceKeyArray3[4] = NSBiomes.TUNDRA;
        } else {
            ResourceKey[] resourceKeyArray4 = new ResourceKey[5];
            resourceKeyArray4[0] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray4[1] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray4[2] = Biomes.WINDSWEPT_HILLS;
            resourceKeyArray4[3] = Biomes.WINDSWEPT_FOREST;
            resourceKeyArray2 = resourceKeyArray4;
            resourceKeyArray4[4] = Biomes.WINDSWEPT_FOREST;
        }
        this.windsweptFrozen = resourceKeyArray2;
        if (NSConfig.hasPrairie) {
            ResourceKey[] resourceKeyArray5 = new ResourceKey[5];
            resourceKeyArray5[0] = NSBiomes.PRAIRIE;
            resourceKeyArray5[1] = NSBiomes.PRAIRIE;
            resourceKeyArray5[2] = NSBiomes.PRAIRIE;
            resourceKeyArray5[3] = NSBiomes.PRAIRIE;
            resourceKeyArray = resourceKeyArray5;
            resourceKeyArray5[4] = NSBiomes.PRAIRIE;
        } else {
            ResourceKey[] resourceKeyArray6 = new ResourceKey[5];
            resourceKeyArray6[0] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray6[1] = Biomes.WINDSWEPT_GRAVELLY_HILLS;
            resourceKeyArray6[2] = Biomes.WINDSWEPT_HILLS;
            resourceKeyArray6[3] = Biomes.WINDSWEPT_FOREST;
            resourceKeyArray = resourceKeyArray6;
            resourceKeyArray6[4] = Biomes.WINDSWEPT_FOREST;
        }
        this.windsweptCold = resourceKeyArray;
        this.frozenTemperature = this.temperatureParameters[0];
        this.nonFrozenTemperatureParameters = Climate.Parameter.span((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
        this.oceanBiomes = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
        this.commonBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeSnowyTaigaFrozen2}, {this.commonBiomePlainsCold, this.commonBiomePlainsCold, this.commonBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {this.commonBiomeFlowerForestTemperate, this.commonBiomePlainsTemperate, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {this.commonBiomeSavannaWarm, this.commonBiomeSavannaWarm, Biomes.FOREST, this.commonBiomeJungleWarm, this.commonBiomeJungleWarm}, {this.commonBiomeDesert, this.commonBiomeDesert, this.commonBiomeDesert, this.commonBiomeDesert2, this.commonBiomeDesert3}};
        this.uncommonBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, this.commonBiomeSnowyTaigaFrozen, null, null}, {this.uncommonBiomePlainsCold, null, null, null, this.uncommonBiomeOldPineCold}, {Biomes.SUNFLOWER_PLAINS, null, null, Biomes.OLD_GROWTH_BIRCH_FOREST, null}, {null, null, this.uncommonBiomePlainsWarm, this.uncommonBiomeSparseJungleWarm, this.uncommonBiomeBambooJungleWarm}, {null, null, this.uncommonBiomeDesert, null, null}};
        this.nearMountainBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeSnowyTaigaFrozen2}, {Biomes.MEADOW, this.mountainBiomeMeadowCold, this.commonBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {this.nearBiomeMeadowTemperate, this.nearBiomeMeadowTemperate, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {this.nearBiomeSavannaPlateauTemperate, this.nearBiomeSavannaPlateauTemperate, this.nearBiomeForestWarm, this.nearBiomeForestWarm, this.commonBiomeJungleWarm}, {this.nearBiomeBadlands, this.nearBiomeBadlands, this.nearBiomeBadlands, this.nearBiomeWoodedBadlands, this.nearBiomeWoodedBadlands}};
        this.specialNearMountainBiomes = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {this.specialBiomeCherryGrove, null, this.mountainBiomeMeadowCold, this.mountainBiomeMeadowCold, this.uncommonBiomeOldPineCold}, {this.specialBiomeCherryGroveTemperate, this.specialBiomeCherryGroveTemperate, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {null, null, null, null, null}, {this.specialBiomeErodedBadlands, this.specialBiomeErodedBadlands, null, null, this.specialBiomeWoodedBadlands}};
        this.windsweptBiomes = new ResourceKey[][]{this.windsweptFrozen, this.windsweptCold, {this.windsweptBiomeWindsweptHillsTemperate, this.windsweptBiomeWindsweptHillsTemperate, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addOffCoastBiomes(parameters);
        this.addInlandBiomes(parameters);
        this.addUndergroundBiomes(parameters);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.addSurfaceBiome(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.addMidSlice(parameters, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(parameters, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(parameters, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(parameters, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(parameters, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(parameters, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(parameters, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey5);
                ResourceKey<Biome> registryKey7 = this.pickPeakBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey7 = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey7 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey8 = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey9 = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                } else {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                    continue;
                }
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> registryKey5 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey6 = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasStratifiedDesert ? registryKey2 : registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey2);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[3], (Climate.Parameter)this.erosionParameters[4]), weirdness, 0.0f, registryKey4);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.FROZEN_RIVER));
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER));
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.span((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.getStratifiedDesertOrRegularBiome(i, j, weirdness);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.addSurfaceBiome(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
            }
        }
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        ResourceKey<Biome> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private ResourceKey<Biome> getStratifiedDesertOrRegularBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? (NSConfig.hasStratifiedDesert ? NSBiomes.STRATIFIED_DESERT : this.pickBadlandsBiome(humidity, weirdness)) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.getStratifiedDesertOrRegularBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && humidity < 4 && weirdness.max() >= 0L ? Biomes.WINDSWEPT_SAVANNA : biomeKey;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = weirdness.max() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature, humidity);
        return this.maybePickWindsweptSavannaBiome(temperature, humidity, weirdness, registryKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature, int humidity) {
        if (temperature == 0) {
            return Biomes.SNOWY_BEACH;
        }
        if (temperature == 3 && NSConfig.hasTropicalShores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? (NSConfig.hasLivelyDunes ? NSBiomes.LIVELY_DUNES : Biomes.DESERT) : Biomes.BEACH;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey;
        if (weirdness.max() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature <= 1 && NSConfig.hasPrairie && humidity <= 2) {
            return Biomes.STONY_PEAKS;
        }
        if (temperature <= 2) {
            return weirdness.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        return temperature == 3 ? Biomes.STONY_PEAKS : (NSConfig.hasStratifiedDesert ? NSBiomes.STRATIFIED_DESERT : this.pickBadlandsBiome(humidity, weirdness));
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidity, Climate.Parameter weirdness) {
        if (humidity < 2) {
            return weirdness.max() < 0L ? Biomes.BADLANDS : Biomes.ERODED_BADLANDS;
        }
        return humidity < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature >= 3) {
            return this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        if (NSConfig.hasTundra || NSConfig.hasSnowyFirForest) {
            return humidity <= 2 && temperature <= 1 && NSConfig.hasTundra ? NSBiomes.TUNDRA : (temperature == 0 && humidity == 3 && NSConfig.hasSnowyFirForest ? NSBiomes.SNOWY_FIR_FOREST : Biomes.GROVE);
        }
        return humidity <= 1 ? Biomes.SNOWY_SLOPES : Biomes.GROVE;
    }

    private ResourceKey<Biome> getWetlandType(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0 || NSConfig.hasLivelyDunes && temperature == 4) {
            return this.pickMiddleBiome(temperature, humidity, weirdness);
        }
        if ((humidity <= 3 || temperature > 2) && NSConfig.hasMarsh) {
            return NSBiomes.MARSH;
        }
        return temperature >= 3 ? Biomes.MANGROVE_SWAMP : Biomes.SWAMP;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : registryKey;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

