/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.hibiscus.naturespirit.blocks.BranchingTrunkBlock;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.hibiscus.naturespirit.blocks.DownwardsVinePlantBlock;
import net.hibiscus.naturespirit.blocks.ParticleLeavesBlock;
import net.hibiscus.naturespirit.blocks.ProjectileLeavesBlock;
import net.hibiscus.naturespirit.blocks.SandySaplingBlock;
import net.hibiscus.naturespirit.blocks.VinesLeavesBlock;
import net.hibiscus.naturespirit.datagen.NSConfiguredFeatures;
import net.hibiscus.naturespirit.entity.NSBoatEntity;
import net.hibiscus.naturespirit.items.NSBoatItem;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class WoodSet {
    private final List<DeferredBlock<? extends Block>> registeredBlocksList = new ArrayList<DeferredBlock<? extends Block>>();
    private final List<DeferredItem<? extends Item>> registeredItemsList = new ArrayList<DeferredItem<? extends Item>>();
    private final String name;
    private final MapColor sideColor;
    private final MapColor topColor;
    private final WoodPreset woodPreset;
    private Supplier<BlockSetType> blockSetType;
    private Supplier<WoodType> woodType;
    private DeferredBlock<? extends Block> log;
    private DeferredBlock<? extends Block> strippedLog;
    private DeferredBlock<RotatedPillarBlock> bundle;
    private DeferredBlock<RotatedPillarBlock> strippedBundle;
    private DeferredBlock<RotatedPillarBlock> wood;
    private DeferredBlock<RotatedPillarBlock> strippedWood;
    private DeferredBlock<? extends LeavesBlock> leaves;
    private DeferredBlock<? extends LeavesBlock> frostyLeaves;
    private DeferredBlock<? extends SaplingBlock> sapling;
    private DeferredBlock<FlowerPotBlock> pottedSapling;
    private DeferredBlock<? extends LeavesBlock> redLeaves;
    private DeferredBlock<? extends SaplingBlock> redSapling;
    private DeferredBlock<FlowerPotBlock> pottedRedSapling;
    private DeferredBlock<? extends LeavesBlock> orangeLeaves;
    private DeferredBlock<? extends SaplingBlock> orangeSapling;
    private DeferredBlock<FlowerPotBlock> pottedOrangeSapling;
    private DeferredBlock<? extends LeavesBlock> yellowLeaves;
    private DeferredBlock<? extends SaplingBlock> yellowSapling;
    private DeferredBlock<FlowerPotBlock> pottedYellowSapling;
    private DeferredBlock<? extends LeavesBlock> blueLeaves;
    private DeferredBlock<? extends LeavesBlock> partBlueLeaves;
    private DeferredBlock<? extends SaplingBlock> blueSapling;
    private DeferredBlock<FlowerPotBlock> pottedBlueSapling;
    private DeferredBlock<? extends LeavesBlock> purpleLeaves;
    private DeferredBlock<? extends LeavesBlock> partPurpleLeaves;
    private DeferredBlock<? extends SaplingBlock> purpleSapling;
    private DeferredBlock<FlowerPotBlock> pottedPurpleSapling;
    private DeferredBlock<? extends LeavesBlock> pinkLeaves;
    private DeferredBlock<? extends LeavesBlock> partPinkLeaves;
    private DeferredBlock<? extends SaplingBlock> pinkSapling;
    private DeferredBlock<FlowerPotBlock> pottedPinkSapling;
    private DeferredBlock<? extends LeavesBlock> whiteLeaves;
    private DeferredBlock<? extends LeavesBlock> partWhiteLeaves;
    private DeferredBlock<? extends SaplingBlock> whiteSapling;
    private DeferredBlock<FlowerPotBlock> pottedWhiteSapling;
    private DeferredBlock<DownwardVineBlock> vines;
    private DeferredBlock<DownwardsVinePlantBlock> vinesPlant;
    private DeferredBlock<DownwardVineBlock> blueVines;
    private DeferredBlock<DownwardVineBlock> purpleVines;
    private DeferredBlock<DownwardVineBlock> pinkVines;
    private DeferredBlock<DownwardVineBlock> whiteVines;
    private DeferredBlock<DownwardsVinePlantBlock> blueVinesPlant;
    private DeferredBlock<DownwardsVinePlantBlock> purpleVinesPlant;
    private DeferredBlock<DownwardsVinePlantBlock> pinkVinesPlant;
    private DeferredBlock<DownwardsVinePlantBlock> whiteVinesPlant;
    private DeferredBlock<Block> planks;
    private DeferredBlock<StairBlock> stairs;
    private DeferredBlock<SlabBlock> slab;
    private DeferredBlock<Block> mosaic;
    private DeferredBlock<StairBlock> mosaicStairs;
    private DeferredBlock<SlabBlock> mosaicSlab;
    private DeferredBlock<FenceBlock> fence;
    private DeferredBlock<FenceGateBlock> fenceGate;
    private DeferredBlock<PressurePlateBlock> pressurePlate;
    private DeferredBlock<ButtonBlock> button;
    private DeferredBlock<DoorBlock> door;
    private DeferredBlock<TrapDoorBlock> trapDoor;
    private DeferredBlock<StandingSignBlock> sign;
    private DeferredBlock<WallSignBlock> wallSign;
    private DeferredBlock<CeilingHangingSignBlock> hangingSign;
    private DeferredBlock<WallHangingSignBlock> hangingWallSign;
    private DeferredItem<SignItem> signItem;
    private DeferredItem<HangingSignItem> hangingSignItem;
    private DeferredItem<NSBoatItem> boatItem;
    private DeferredItem<NSBoatItem> chestBoatItem;
    private final Supplier<NSBoatEntity.Type> boatType;
    private final TreeGrower saplingGenerator;
    private final boolean hasMosaic;

    private void registerWood() {
        this.blockSetType = this.createBlockSetType();
        this.woodType = Suppliers.memoize(() -> WoodType.register((WoodType)new WoodType("natures_spirit:" + this.getName(), this.blockSetType.get())));
        this.log = this.woodPreset == WoodPreset.JOSHUA ? this.createJoshuaLog() : this.createLog();
        Object object = this.strippedLog = this.woodPreset == WoodPreset.JOSHUA ? this.createStrippedJoshuaLog() : this.createStrippedLog();
        if (this.woodPreset == WoodPreset.JOSHUA) {
            this.bundle = this.createBundle();
            this.strippedBundle = this.createStrippedBundle();
        }
        if (this.woodPreset != WoodPreset.BAMBOO && this.woodPreset != WoodPreset.JOSHUA) {
            this.wood = this.createWood();
            this.strippedWood = this.createStrippedWood();
        }
        if (this.hasDefaultLeaves()) {
            this.leaves = this.createLeaves();
            if (this.hasDefaultSapling()) {
                this.sapling = this.isSandy() ? this.createSandySapling(this.saplingGenerator) : this.createSapling(this.saplingGenerator);
                this.pottedSapling = this.createPottedSapling(this.sapling);
            }
        }
        if (this.woodPreset == WoodPreset.FROSTABLE) {
            this.frostyLeaves = this.createLeaves("frosty_");
            this.leaves = this.createFrostableLeaves();
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
        }
        if (this.woodPreset == WoodPreset.WILLOW) {
            this.vines = this.createVines(this::getVinesPlant);
            this.vinesPlant = this.createVinesPlant(this.vines);
            this.leaves = this.createVinesLeavesBlock(this.vinesPlant, this.vines);
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
        }
        if (this.woodPreset == WoodPreset.WISTERIA) {
            this.whiteVines = this.createVines("white_", this::getWhiteVinesPlant);
            this.blueVines = this.createVines("blue_", this::getBlueVinesPlant);
            this.pinkVines = this.createVines("pink_", this::getPinkVinesPlant);
            this.purpleVines = this.createVines("purple_", this::getPurpleVinesPlant);
            this.whiteVinesPlant = this.createVinesPlant("white_", this.whiteVines);
            this.blueVinesPlant = this.createVinesPlant("blue_", this.blueVines);
            this.pinkVinesPlant = this.createVinesPlant("pink_", this.pinkVines);
            this.purpleVinesPlant = this.createVinesPlant("purple_", this.purpleVines);
            this.whiteLeaves = this.createVinesLeavesBlock("white_", this.whiteVinesPlant, this.whiteVines);
            this.partWhiteLeaves = this.createVinesLeavesBlock("part_white_", this.whiteVinesPlant, this.whiteVines);
            this.blueLeaves = this.createVinesLeavesBlock("blue_", this.blueVinesPlant, this.blueVines);
            this.partBlueLeaves = this.createVinesLeavesBlock("part_blue_", this.blueVinesPlant, this.blueVines);
            this.pinkLeaves = this.createVinesLeavesBlock("pink_", this.pinkVinesPlant, this.pinkVines);
            this.partPinkLeaves = this.createVinesLeavesBlock("part_pink_", this.pinkVinesPlant, this.pinkVines);
            this.purpleLeaves = this.createVinesLeavesBlock("purple_", this.purpleVinesPlant, this.purpleVines);
            this.partPurpleLeaves = this.createVinesLeavesBlock("part_purple_", this.purpleVinesPlant, this.purpleVines);
            this.whiteSapling = this.createSapling("white_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.WHITE_WISTERIA_TREE), Optional.empty()));
            this.blueSapling = this.createSapling("blue_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.BLUE_WISTERIA_TREE), Optional.empty()));
            this.pinkSapling = this.createSapling("pink_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.PINK_WISTERIA_TREE), Optional.empty()));
            this.purpleSapling = this.createSapling("purple_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.PURPLE_WISTERIA_TREE), Optional.empty()));
            this.pottedWhiteSapling = this.createPottedSapling("white_", this.whiteSapling);
            this.pottedBlueSapling = this.createPottedSapling("blue_", this.blueSapling);
            this.pottedPinkSapling = this.createPottedSapling("pink_", this.pinkSapling);
            this.pottedPurpleSapling = this.createPottedSapling("purple_", this.purpleSapling);
        }
        if (this.woodPreset == WoodPreset.MAPLE) {
            this.redLeaves = this.createParticleLeaves("red_", NSParticleTypes.RED_MAPLE_LEAVES_PARTICLE, 100);
            this.orangeLeaves = this.createParticleLeaves("orange_", NSParticleTypes.ORANGE_MAPLE_LEAVES_PARTICLE, 100);
            this.yellowLeaves = this.createParticleLeaves("yellow_", NSParticleTypes.YELLOW_MAPLE_LEAVES_PARTICLE, 100);
            this.redSapling = this.createSapling("red_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.RED_MAPLE_TREE), Optional.empty()));
            this.orangeSapling = this.createSapling("orange_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.ORANGE_MAPLE_TREE), Optional.empty()));
            this.yellowSapling = this.createSapling("yellow_", new TreeGrower("natures_spirit_" + this.getName(), Optional.empty(), Optional.of(NSConfiguredFeatures.YELLOW_MAPLE_TREE), Optional.empty()));
            this.pottedRedSapling = this.createPottedSapling("red_", this.redSapling);
            this.pottedOrangeSapling = this.createPottedSapling("orange_", this.orangeSapling);
            this.pottedYellowSapling = this.createPottedSapling("yellow_", this.yellowSapling);
        }
        if (this.woodPreset == WoodPreset.ASPEN) {
            this.yellowLeaves = this.createLeaves("yellow_");
        }
        if (this.hasMosaic()) {
            this.mosaic = this.createMosaic();
            this.mosaicStairs = this.createMosaicStairs();
            this.mosaicSlab = this.createMosaicSlab();
        }
        this.planks = this.createPlanks();
        this.stairs = this.createStairs();
        this.slab = this.createSlab();
        this.fence = this.createFence();
        this.fenceGate = this.createFenceGate();
        this.pressurePlate = this.createPressurePlate();
        this.button = this.createButton();
        this.door = this.createDoor();
        this.trapDoor = this.createTrapDoor();
        this.sign = this.createSign();
        this.wallSign = this.createWallSign();
        this.hangingSign = this.createHangingSign();
        this.hangingWallSign = this.createWallHangingSign();
        this.signItem = this.createSignItem();
        this.hangingSignItem = this.createHangingSignItem();
        this.boatItem = this.createItem(this.getName() + "_boat", () -> new NSBoatItem(false, this.boatType.get(), new Item.Properties().stacksTo(1)));
        this.chestBoatItem = this.createItem(this.getName() + "_chest_boat", () -> new NSBoatItem(true, this.boatType.get(), new Item.Properties().stacksTo(1)));
    }

    public WoodSet(String name, MapColor sideColor, MapColor topColor, Supplier<NSBoatEntity.Type> boatType, WoodPreset woodPreset, boolean hasMosaic, TreeGrower saplingGenerator) {
        this.woodPreset = woodPreset;
        this.name = name;
        this.sideColor = sideColor;
        this.topColor = topColor;
        this.boatType = boatType;
        this.saplingGenerator = saplingGenerator;
        this.hasMosaic = hasMosaic;
        this.registerWood();
    }

    public String getName() {
        return this.name;
    }

    public Supplier<BlockSetType> getBlockSetType() {
        return this.blockSetType;
    }

    public WoodPreset getWoodPreset() {
        return this.woodPreset;
    }

    public MapColor getTopColor() {
        return this.topColor;
    }

    public Supplier<WoodType> getWoodType() {
        return this.woodType;
    }

    public DeferredBlock<ButtonBlock> getButton() {
        return this.button;
    }

    public DeferredBlock<FenceBlock> getFence() {
        return this.fence;
    }

    public DeferredBlock<Block> getPlanks() {
        return this.planks;
    }

    public DeferredBlock<SlabBlock> getSlab() {
        return this.slab;
    }

    public DeferredBlock<FenceGateBlock> getFenceGate() {
        return this.fenceGate;
    }

    public DeferredBlock<StairBlock> getStairs() {
        return this.stairs;
    }

    public DeferredBlock<DoorBlock> getDoor() {
        return this.door;
    }

    public DeferredBlock<CeilingHangingSignBlock> getHangingSign() {
        return this.hangingSign;
    }

    public DeferredBlock<WallHangingSignBlock> getHangingWallSign() {
        return this.hangingWallSign;
    }

    public DeferredBlock<PressurePlateBlock> getPressurePlate() {
        return this.pressurePlate;
    }

    public DeferredBlock<StandingSignBlock> getSign() {
        return this.sign;
    }

    public DeferredBlock<TrapDoorBlock> getTrapDoor() {
        return this.trapDoor;
    }

    public DeferredBlock<WallSignBlock> getWallSign() {
        return this.wallSign;
    }

    public DeferredItem<HangingSignItem> getHangingSignItem() {
        return this.hangingSignItem;
    }

    public DeferredItem<SignItem> getSignItem() {
        return this.signItem;
    }

    public DeferredItem<NSBoatItem> getBoatItem() {
        return this.boatItem;
    }

    public DeferredItem<NSBoatItem> getChestBoatItem() {
        return this.chestBoatItem;
    }

    public DeferredBlock<? extends Block> getLog() {
        return this.log;
    }

    public DeferredBlock<? extends Block> getStrippedLog() {
        return this.strippedLog;
    }

    public DeferredBlock<RotatedPillarBlock> getBundle() {
        return this.bundle;
    }

    public DeferredBlock<RotatedPillarBlock> getStrippedBundle() {
        return this.strippedBundle;
    }

    public DeferredBlock<RotatedPillarBlock> getWood() {
        return this.wood;
    }

    public DeferredBlock<RotatedPillarBlock> getStrippedWood() {
        return this.strippedWood;
    }

    public DeferredBlock<Block> getMosaic() {
        return this.mosaic;
    }

    public DeferredBlock<StairBlock> getMosaicStairs() {
        return this.mosaicStairs;
    }

    public DeferredBlock<SlabBlock> getMosaicSlab() {
        return this.mosaicSlab;
    }

    public DeferredBlock<? extends LeavesBlock> getLeaves() {
        return this.leaves;
    }

    public DeferredBlock<? extends LeavesBlock> getFrostyLeaves() {
        return this.frostyLeaves;
    }

    public DeferredBlock<? extends SaplingBlock> getSapling() {
        return this.sapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedSapling() {
        return this.pottedSapling;
    }

    public DeferredBlock<DownwardVineBlock> getVines() {
        return this.vines;
    }

    public DeferredBlock<DownwardsVinePlantBlock> getVinesPlant() {
        return this.vinesPlant;
    }

    public DeferredBlock<? extends LeavesBlock> getRedLeaves() {
        return this.redLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getOrangeLeaves() {
        return this.orangeLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getYellowLeaves() {
        return this.yellowLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getBlueLeaves() {
        return this.blueLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getPurpleLeaves() {
        return this.purpleLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getPinkLeaves() {
        return this.pinkLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getWhiteLeaves() {
        return this.whiteLeaves;
    }

    public DeferredBlock<FlowerPotBlock> getPottedRedSapling() {
        return this.pottedRedSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedOrangeSapling() {
        return this.pottedOrangeSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedYellowSapling() {
        return this.pottedYellowSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedBlueSapling() {
        return this.pottedBlueSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedPurpleSapling() {
        return this.pottedPurpleSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedPinkSapling() {
        return this.pottedPinkSapling;
    }

    public DeferredBlock<FlowerPotBlock> getPottedWhiteSapling() {
        return this.pottedWhiteSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getRedSapling() {
        return this.redSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getOrangeSapling() {
        return this.orangeSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getYellowSapling() {
        return this.yellowSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getBlueSapling() {
        return this.blueSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getPurpleSapling() {
        return this.purpleSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getPinkSapling() {
        return this.pinkSapling;
    }

    public DeferredBlock<? extends SaplingBlock> getWhiteSapling() {
        return this.whiteSapling;
    }

    public DeferredBlock<DownwardVineBlock> getBlueVines() {
        return this.blueVines;
    }

    public DeferredBlock<DownwardVineBlock> getPurpleVines() {
        return this.purpleVines;
    }

    public DeferredBlock<DownwardVineBlock> getPinkVines() {
        return this.pinkVines;
    }

    public DeferredBlock<DownwardVineBlock> getWhiteVines() {
        return this.whiteVines;
    }

    public DeferredBlock<DownwardsVinePlantBlock> getBlueVinesPlant() {
        return this.blueVinesPlant;
    }

    public DeferredBlock<DownwardsVinePlantBlock> getPurpleVinesPlant() {
        return this.purpleVinesPlant;
    }

    public DeferredBlock<DownwardsVinePlantBlock> getPinkVinesPlant() {
        return this.pinkVinesPlant;
    }

    public DeferredBlock<DownwardsVinePlantBlock> getWhiteVinesPlant() {
        return this.whiteVinesPlant;
    }

    public DeferredBlock<? extends LeavesBlock> getPartBlueLeaves() {
        return this.partBlueLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getPartPurpleLeaves() {
        return this.partPurpleLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getPartPinkLeaves() {
        return this.partPinkLeaves;
    }

    public DeferredBlock<? extends LeavesBlock> getPartWhiteLeaves() {
        return this.partWhiteLeaves;
    }

    private String getWoodName() {
        String name = this.woodPreset == WoodPreset.NETHER ? this.getName() + "_hyphae" : this.getName() + "_wood";
        return name;
    }

    private String getLogName() {
        String name = this.woodPreset == WoodPreset.BAMBOO ? this.getName() + "_block" : (this.woodPreset == WoodPreset.NETHER ? this.getName() + "_stem" : this.getName() + "_log");
        return name;
    }

    private Block getBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.BAMBOO_PLANKS : (this.woodPreset == WoodPreset.FANCY ? Blocks.CHERRY_PLANKS : (this.woodPreset == WoodPreset.NETHER ? Blocks.CRIMSON_PLANKS : Blocks.OAK_PLANKS));
        return base;
    }

    private Block getSignBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.BAMBOO_SIGN : (this.woodPreset == WoodPreset.FANCY ? Blocks.CHERRY_SIGN : (this.woodPreset == WoodPreset.NETHER ? Blocks.CRIMSON_SIGN : Blocks.OAK_SIGN));
        return base;
    }

    private Block getHangingSignBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.BAMBOO_HANGING_SIGN : (this.woodPreset == WoodPreset.FANCY ? Blocks.CHERRY_HANGING_SIGN : (this.woodPreset == WoodPreset.NETHER ? Blocks.CRIMSON_HANGING_SIGN : Blocks.OAK_HANGING_SIGN));
        return base;
    }

    public Supplier<NSBoatEntity.Type> getBoatType() {
        return this.boatType;
    }

    public List<DeferredBlock<? extends Block>> getRegisteredBlocksList() {
        return ImmutableList.copyOf(this.registeredBlocksList);
    }

    public List<DeferredItem<? extends Item>> getRegisteredItemsList() {
        return ImmutableList.copyOf(this.registeredItemsList);
    }

    private <T extends Block> DeferredBlock<T> createBlockWithItem(String blockID, Supplier<T> block) {
        DeferredBlock<T> listBlock = NSRegistryHelper.registerBlock(blockID, block);
        this.registeredBlocksList.add(listBlock);
        return listBlock;
    }

    private <T extends Block> DeferredBlock<T> createBlockWithoutItem(String blockID, Supplier<T> block) {
        DeferredBlock<T> listBlock = NSRegistryHelper.registerBlockWithoutItem(blockID, block);
        this.registeredBlocksList.add(listBlock);
        return listBlock;
    }

    public <T extends Item> DeferredItem<T> createItem(String blockID, Supplier<T> item) {
        DeferredItem<T> listItem = NSRegistryHelper.registerItem(blockID, item);
        this.registeredItemsList.add(listItem);
        return listItem;
    }

    private DeferredBlock<RotatedPillarBlock> createLog() {
        return this.createBlockWithItem(this.getLogName(), () -> WoodSet.log(this.topColor, this.sideColor));
    }

    private DeferredBlock<RotatedPillarBlock> createStrippedLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), () -> WoodSet.log(this.topColor, this.sideColor));
    }

    private DeferredBlock<RotatedPillarBlock> createBundle() {
        return this.createBlockWithItem(this.getName() + "_bundle", () -> WoodSet.log(this.topColor, this.sideColor));
    }

    private DeferredBlock<RotatedPillarBlock> createStrippedBundle() {
        return this.createBlockWithItem("stripped_" + this.getName() + "_bundle", () -> WoodSet.log(this.topColor, this.sideColor));
    }

    private static RotatedPillarBlock log(MapColor p_285370_, MapColor p_285126_) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? p_285370_ : p_285126_).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava()){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        };
    }

    private DeferredBlock<BranchingTrunkBlock> createJoshuaLog() {
        return this.createBlockWithItem(this.getLogName(), () -> new BranchingTrunkBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    }

    private DeferredBlock<BranchingTrunkBlock> createStrippedJoshuaLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), () -> new BranchingTrunkBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    }

    private DeferredBlock<RotatedPillarBlock> createWood() {
        return this.createBlockWithItem(this.getWoodName(), () -> WoodSet.log(this.sideColor, this.sideColor));
    }

    private DeferredBlock<RotatedPillarBlock> createStrippedWood() {
        return this.createBlockWithItem("stripped_" + this.getWoodName(), () -> WoodSet.log(this.topColor, this.topColor));
    }

    private DeferredBlock<LeavesBlock> createLeaves() {
        DeferredBlock<LeavesBlock> block = this.createBlockWithItem(this.getName() + "_leaves", () -> new LeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private DeferredBlock<LeavesBlock> createLeaves(String prefix) {
        DeferredBlock<LeavesBlock> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", () -> new LeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private DeferredBlock<ProjectileLeavesBlock> createFrostableLeaves() {
        DeferredBlock<ProjectileLeavesBlock> block = this.createBlockWithItem(this.getName() + "_leaves", () -> new ProjectileLeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), this.frostyLeaves){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private DeferredBlock<ProjectileLeavesBlock> createFrostableLeaves(String prefix) {
        DeferredBlock<ProjectileLeavesBlock> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", () -> new ProjectileLeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), this.frostyLeaves){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private DeferredBlock<ParticleLeavesBlock> createParticleLeaves(Supplier<? extends ParticleOptions> particle, int chance) {
        DeferredBlock<ParticleLeavesBlock> block = this.createBlockWithItem(this.getName() + "_leaves", () -> new ParticleLeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), particle, chance){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private DeferredBlock<ParticleLeavesBlock> createParticleLeaves(String prefix, Supplier<? extends ParticleOptions> particle, int chance) {
        DeferredBlock<ParticleLeavesBlock> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", () -> new ParticleLeavesBlock(this, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), particle, chance){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private DeferredBlock<VinesLeavesBlock> createVinesLeavesBlock(DeferredBlock<DownwardsVinePlantBlock> vinesPlantBlock, DeferredBlock<DownwardVineBlock> vinesTipBlock) {
        DeferredBlock<VinesLeavesBlock> block = this.createBlockWithItem(this.getName() + "_leaves", () -> new VinesLeavesBlock(this, BlockBehaviour.Properties.of().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), vinesPlantBlock, vinesTipBlock){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private DeferredBlock<VinesLeavesBlock> createVinesLeavesBlock(String prefix, DeferredBlock<DownwardsVinePlantBlock> vinesPlantBlock, DeferredBlock<DownwardVineBlock> vinesTipBlock) {
        DeferredBlock<VinesLeavesBlock> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", () -> new VinesLeavesBlock(this, BlockBehaviour.Properties.of().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(NSRegistryHelper::ocelotOrParrot).isSuffocating(NSRegistryHelper::never).isViewBlocking(NSRegistryHelper::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(NSRegistryHelper::never), vinesPlantBlock, vinesTipBlock){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        });
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private DeferredBlock<DownwardVineBlock> createVines(Supplier<DeferredBlock<DownwardsVinePlantBlock>> vinesPlantBlock) {
        DeferredBlock<DownwardVineBlock> vinesBlock = this.createBlockWithItem(this.getName() + "_vines", () -> new DownwardVineBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).randomTicks().noCollission().noOcclusion().instabreak().sound(SoundType.WEEPING_VINES), vinesPlantBlock));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines", vinesBlock);
        return vinesBlock;
    }

    private DeferredBlock<DownwardVineBlock> createVines(String prefix, Supplier<DeferredBlock<DownwardsVinePlantBlock>> vinesPlantBlock) {
        DeferredBlock<DownwardVineBlock> vinesBlock = this.createBlockWithItem(prefix + this.getName() + "_vines", () -> new DownwardVineBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).randomTicks().noCollission().noOcclusion().instabreak().sound(SoundType.WEEPING_VINES), vinesPlantBlock));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines", vinesBlock);
        return vinesBlock;
    }

    private DeferredBlock<DownwardsVinePlantBlock> createVinesPlant(DeferredBlock<DownwardVineBlock> vines) {
        DeferredBlock<DownwardsVinePlantBlock> vinesPlant = NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_vines_plant", () -> new DownwardsVinePlantBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().noOcclusion().instabreak().sound(SoundType.WEEPING_VINES).dropsLike((Block)vines.get()), vines));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private DeferredBlock<DownwardsVinePlantBlock> createVinesPlant(String prefix, DeferredBlock<DownwardVineBlock> vines) {
        DeferredBlock<DownwardsVinePlantBlock> vinesPlant = NSRegistryHelper.registerBlockWithoutItem(prefix + this.getName() + "_vines_plant", () -> new DownwardsVinePlantBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().noOcclusion().instabreak().sound(SoundType.WEEPING_VINES).dropsLike((Block)vines.get()), vines));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private DeferredBlock<Block> createPlanks() {
        return this.createBlockWithItem(this.getName() + "_planks", () -> new Block(this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    private DeferredBlock<StairBlock> createStairs() {
        return this.createBlockWithItem(this.getName() + "_stairs", () -> new StairBlock(this, this.getBase().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    private DeferredBlock<SlabBlock> createSlab() {
        return this.createBlockWithItem(this.getName() + "_slab", () -> new SlabBlock(this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    private DeferredBlock<Block> createMosaic() {
        DeferredBlock<Block> block = this.createBlockWithoutItem(this.getName() + "_mosaic", () -> new Block(this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
        NSRegistryHelper.registerItem(this.getName() + "_mosaic", () -> new BlockItem(this, (Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 300;
            }
        });
        return block;
    }

    private DeferredBlock<StairBlock> createMosaicStairs() {
        DeferredBlock<StairBlock> block = this.createBlockWithoutItem(this.getName() + "_mosaic_stairs", () -> new StairBlock(this, this.getBase().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
        NSRegistryHelper.registerItem(this.getName() + "_mosaic_stairs", () -> new BlockItem(this, (Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 300;
            }
        });
        return block;
    }

    private DeferredBlock<SlabBlock> createMosaicSlab() {
        DeferredBlock<SlabBlock> block = this.createBlockWithoutItem(this.getName() + "_mosaic_slab", () -> new SlabBlock(this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
        NSRegistryHelper.registerItem(this.getName() + "_mosaic_slab", () -> new BlockItem(this, (Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 150;
            }
        });
        return block;
    }

    private DeferredBlock<FenceBlock> createFence() {
        return this.createBlockWithItem(this.getName() + "_fence", () -> new FenceBlock(this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).mapColor(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    private DeferredBlock<FenceGateBlock> createFenceGate() {
        return this.createBlockWithItem(this.getName() + "_fence_gate", () -> new FenceGateBlock(this, this.getWoodType().get(), BlockBehaviour.Properties.of().mapColor(this.getBase().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava()){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    private DeferredBlock<PressurePlateBlock> createPressurePlate() {
        return this.createBlockWithItem(this.getName() + "_pressure_plate", () -> new PressurePlateBlock(this.getBlockSetType().get(), BlockBehaviour.Properties.of().mapColor(this.getBase().defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY)));
    }

    private DeferredBlock<ButtonBlock> createButton() {
        return this.createBlockWithItem(this.getName() + "_button", () -> new ButtonBlock(this.getBlockSetType().get(), 30, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY)));
    }

    private DeferredBlock<DoorBlock> createDoor() {
        DeferredBlock<DoorBlock> block = this.createBlockWithItem(this.getName() + "_door", () -> new DoorBlock(this.getBlockSetType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).noOcclusion().mapColor(this.getTopColor())));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_door", block);
        return block;
    }

    private DeferredBlock<TrapDoorBlock> createTrapDoor() {
        DeferredBlock<TrapDoorBlock> block = this.createBlockWithItem(this.getName() + "_trapdoor", () -> new TrapDoorBlock(this.getBlockSetType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getBase()).sound(this.getBlockSetType().get().soundType()).noOcclusion().mapColor(this.getTopColor())));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_trapdoor", block);
        return block;
    }

    private DeferredBlock<StandingSignBlock> createSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_sign", () -> new StandingSignBlock(this.getWoodType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getSignBase()).mapColor(this.getTopColor())));
    }

    private DeferredBlock<WallSignBlock> createWallSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_wall_sign", () -> new WallSignBlock(this.getWoodType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getSignBase()).mapColor(this.getTopColor()).dropsLike((Block)this.sign.get())));
    }

    private DeferredBlock<CeilingHangingSignBlock> createHangingSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_hanging_sign", () -> new CeilingHangingSignBlock(this.getWoodType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getHangingSignBase()).mapColor(this.getTopColor())));
    }

    private DeferredBlock<WallHangingSignBlock> createWallHangingSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_wall_hanging_sign", () -> new WallHangingSignBlock(this.getWoodType().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getHangingSignBase()).mapColor(this.getTopColor()).dropsLike((Block)this.hangingSign.get())));
    }

    public DeferredBlock<SaplingBlock> createSapling(TreeGrower saplingGenerator) {
        DeferredBlock<SaplingBlock> block = this.createBlockWithItem(this.getName() + "_sapling", () -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SAPLING)));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        return block;
    }

    public DeferredBlock<SandySaplingBlock> createSandySapling(TreeGrower saplingGenerator) {
        DeferredBlock<SandySaplingBlock> block = this.createBlockWithItem(this.getName() + "_sapling", () -> new SandySaplingBlock(saplingGenerator, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SAPLING)));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        return block;
    }

    public DeferredBlock<FlowerPotBlock> createPottedSapling(DeferredBlock<? extends SaplingBlock> sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + this.getName() + "_sapling", () -> new FlowerPotBlock(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).getEmptyPot(), (Supplier)sapling, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    }

    public DeferredBlock<SaplingBlock> createSapling(String prefix, TreeGrower saplingGenerator) {
        DeferredBlock<SaplingBlock> block = this.createBlockWithItem(prefix + this.getName() + "_sapling", () -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SAPLING)));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        return block;
    }

    public DeferredBlock<SandySaplingBlock> createSandySapling(String prefix, TreeGrower saplingGenerator) {
        DeferredBlock<SandySaplingBlock> block = this.createBlockWithItem(prefix + this.getName() + "_sapling", () -> new SandySaplingBlock(saplingGenerator, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SAPLING)));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        return block;
    }

    public DeferredBlock<FlowerPotBlock> createPottedSapling(String prefix, DeferredBlock<? extends SaplingBlock> sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + prefix + this.getName() + "_sapling", () -> new FlowerPotBlock(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).getEmptyPot(), (Supplier)sapling, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    }

    private DeferredItem<SignItem> createSignItem() {
        return this.createItem(this.getName() + "_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)this.sign.get(), (Block)this.wallSign.get()));
    }

    private DeferredItem<HangingSignItem> createHangingSignItem() {
        return this.createItem(this.getName() + "_hanging_sign", () -> new HangingSignItem((Block)this.hangingSign.get(), (Block)this.hangingWallSign.get(), new Item.Properties().stacksTo(16)));
    }

    private Supplier<BlockSetType> createBlockSetType() {
        if (this.woodPreset == WoodPreset.BAMBOO) {
            return Suppliers.memoize(() -> BlockSetType.register((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.BAMBOO_WOOD, SoundEvents.BAMBOO_WOOD_DOOR_CLOSE, SoundEvents.BAMBOO_WOOD_DOOR_OPEN, SoundEvents.BAMBOO_WOOD_TRAPDOOR_CLOSE, SoundEvents.BAMBOO_WOOD_TRAPDOOR_OPEN, SoundEvents.BAMBOO_WOOD_PRESSURE_PLATE_CLICK_OFF, SoundEvents.BAMBOO_WOOD_PRESSURE_PLATE_CLICK_ON, SoundEvents.BAMBOO_WOOD_BUTTON_CLICK_OFF, SoundEvents.BAMBOO_WOOD_BUTTON_CLICK_ON)));
        }
        if (this.woodPreset == WoodPreset.FANCY) {
            return Suppliers.memoize(() -> BlockSetType.register((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.CHERRY_WOOD, SoundEvents.CHERRY_WOOD_DOOR_CLOSE, SoundEvents.CHERRY_WOOD_DOOR_OPEN, SoundEvents.CHERRY_WOOD_TRAPDOOR_CLOSE, SoundEvents.CHERRY_WOOD_TRAPDOOR_OPEN, SoundEvents.CHERRY_WOOD_PRESSURE_PLATE_CLICK_OFF, SoundEvents.CHERRY_WOOD_PRESSURE_PLATE_CLICK_ON, SoundEvents.CHERRY_WOOD_BUTTON_CLICK_OFF, SoundEvents.CHERRY_WOOD_BUTTON_CLICK_ON)));
        }
        if (this.woodPreset == WoodPreset.NETHER) {
            return Suppliers.memoize(() -> BlockSetType.register((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.NETHER_WOOD, SoundEvents.NETHER_WOOD_DOOR_CLOSE, SoundEvents.NETHER_WOOD_DOOR_OPEN, SoundEvents.NETHER_WOOD_TRAPDOOR_CLOSE, SoundEvents.NETHER_WOOD_TRAPDOOR_OPEN, SoundEvents.NETHER_WOOD_PRESSURE_PLATE_CLICK_OFF, SoundEvents.NETHER_WOOD_PRESSURE_PLATE_CLICK_ON, SoundEvents.NETHER_WOOD_BUTTON_CLICK_OFF, SoundEvents.NETHER_WOOD_BUTTON_CLICK_ON)));
        }
        return Suppliers.memoize(() -> BlockSetType.register((BlockSetType)new BlockSetType("natures_spirit:" + this.getName())));
    }

    public boolean isSandy() {
        return this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.SANDY;
    }

    public boolean hasDefaultLeaves() {
        return this.woodPreset == WoodPreset.DEFAULT || this.woodPreset == WoodPreset.WISTERIA || this.woodPreset == WoodPreset.FANCY || this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.NO_SAPLING || this.woodPreset == WoodPreset.SANDY || this.woodPreset == WoodPreset.ASPEN;
    }

    public boolean hasDefaultSapling() {
        return this.woodPreset != WoodPreset.NO_SAPLING && this.woodPreset != WoodPreset.WISTERIA;
    }

    public boolean hasBark() {
        return this.woodPreset != WoodPreset.JOSHUA && this.woodPreset != WoodPreset.BAMBOO;
    }

    public boolean hasMosaic() {
        return this.hasMosaic;
    }

    public static enum WoodPreset {
        DEFAULT,
        MAPLE,
        ASPEN,
        FROSTABLE,
        JOSHUA,
        SANDY,
        NO_SAPLING,
        WISTERIA,
        WILLOW,
        FANCY,
        NETHER,
        BAMBOO;

    }
}

