/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.base.Supplier;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;

public class StoneSet {
    private DeferredBlock<Block> cobbled;
    private DeferredBlock<StairBlock> cobbledStairs;
    private DeferredBlock<SlabBlock> cobbledSlab;
    private DeferredBlock<WallBlock> cobbledWall;
    private DeferredBlock<Block> mossyCobbled;
    private DeferredBlock<StairBlock> mossyCobbledStairs;
    private DeferredBlock<SlabBlock> mossyCobbledSlab;
    private DeferredBlock<WallBlock> mossyCobbledWall;
    private DeferredBlock<? extends Block> base;
    private DeferredBlock<StairBlock> baseStairs;
    private DeferredBlock<SlabBlock> baseSlab;
    private DeferredBlock<Block> polished;
    private DeferredBlock<StairBlock> polishedStairs;
    private DeferredBlock<SlabBlock> polishedSlab;
    private DeferredBlock<WallBlock> polishedWall;
    private DeferredBlock<Block> tiles;
    private DeferredBlock<StairBlock> tilesStairs;
    private DeferredBlock<SlabBlock> tilesSlab;
    private DeferredBlock<WallBlock> tilesWall;
    private DeferredBlock<Block> bricks;
    private DeferredBlock<StairBlock> bricksStairs;
    private DeferredBlock<SlabBlock> bricksSlab;
    private DeferredBlock<WallBlock> bricksWall;
    private DeferredBlock<Block> chiseled;
    private DeferredBlock<Block> crackedBricks;
    private DeferredBlock<Block> crackedTiles;
    private DeferredBlock<Block> mossyBricks;
    private DeferredBlock<StairBlock> mossyBricksStairs;
    private DeferredBlock<SlabBlock> mossyBricksSlab;
    private DeferredBlock<WallBlock> mossyBricksWall;
    private final String name;
    private final MapColor mapColor;
    private final boolean hasTiles;
    private final boolean hasCobbled;
    private final boolean hasCracked;
    private final boolean hasMossy;
    private boolean isRotatable;
    private final float hardness;

    private void registerStone() {
        this.base = this.isRotatable ? this.createRotatable(this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.ANDESITE)) : this.createBasic(this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.ANDESITE));
        this.baseStairs = this.createStairs(this.getName(), this.base);
        this.baseSlab = this.createSlab(this.getName(), this.base);
        this.chiseled = this.createBasic("chiseled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.CHISELED_STONE_BRICKS));
        if (this.hasCobbled()) {
            this.cobbled = this.createBasic("cobbled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.COBBLESTONE));
            this.cobbledStairs = this.createStairs("cobbled_" + this.getName(), this.cobbled);
            this.cobbledSlab = this.createSlab("cobbled_" + this.getName(), this.cobbled);
            this.cobbledWall = this.createWall("cobbled_" + this.getName(), this.cobbled);
        }
        if (this.hasMossy() && this.hasCobbled()) {
            this.mossyCobbled = this.createBasic("mossy_cobbled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.MOSSY_COBBLESTONE));
            this.mossyCobbledStairs = this.createStairs("mossy_cobbled_" + this.getName(), this.mossyCobbled);
            this.mossyCobbledSlab = this.createSlab("mossy_cobbled_" + this.getName(), this.mossyCobbled);
            this.mossyCobbledWall = this.createWall("mossy_cobbled_" + this.getName(), this.mossyCobbled);
        }
        this.polished = this.createBasic("polished_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.POLISHED_ANDESITE));
        this.polishedStairs = this.createStairs("polished_" + this.getName(), this.polished);
        this.polishedSlab = this.createSlab("polished_" + this.getName(), this.polished);
        this.polishedWall = this.createWall("polished_" + this.getName(), this.polished);
        this.bricks = this.createBasic(this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.STONE_BRICKS));
        this.bricksStairs = this.createStairs(this.getName() + "_brick", this.bricks);
        this.bricksSlab = this.createSlab(this.getName() + "_brick", this.bricks);
        this.bricksWall = this.createWall(this.getName() + "_brick", this.bricks);
        if (this.hasMossy()) {
            this.mossyBricks = this.createBasic("mossy_" + this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.MOSSY_STONE_BRICKS));
            this.mossyBricksStairs = this.createStairs("mossy_" + this.getName() + "_brick", this.bricks);
            this.mossyBricksSlab = this.createSlab("mossy_" + this.getName() + "_brick", this.bricks);
            this.mossyBricksWall = this.createWall("mossy_" + this.getName() + "_brick", this.bricks);
        }
        if (this.hasCracked()) {
            this.crackedBricks = this.createBasic("cracked_" + this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.CRACKED_STONE_BRICKS));
        }
        if (this.hasTiles()) {
            this.tiles = this.createBasic(this.getName() + "_tiles", (Supplier<Block>)((Supplier)() -> Blocks.COBBLESTONE));
            this.tilesStairs = this.createStairs(this.getName() + "_tile", this.polished);
            this.tilesSlab = this.createSlab(this.getName() + "_tile", this.polished);
            this.tilesWall = this.createWall(this.getName() + "_tile", this.polished);
            if (this.hasCracked()) {
                this.crackedTiles = this.createBasic("cracked_" + this.getName() + "_tiles", (Supplier<Block>)((Supplier)() -> Blocks.CRACKED_STONE_BRICKS));
            }
        }
    }

    public StoneSet(String name, MapColor mapColor, float hardness, boolean hasCobbled, boolean hasCracked, boolean hasMossy, boolean hasTiles) {
        this.name = name;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.hasTiles = hasTiles;
        this.hasCobbled = hasCobbled;
        this.hasCracked = hasCracked;
        this.hasMossy = hasMossy;
        this.registerStone();
    }

    public StoneSet(String name, MapColor mapColor, float hardness, boolean hasCobbled, boolean hasCracked, boolean hasMossy, boolean hasTiles, boolean isRotatable) {
        this.name = name;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.hasTiles = hasTiles;
        this.hasCobbled = hasCobbled;
        this.hasCracked = hasCracked;
        this.hasMossy = hasMossy;
        this.isRotatable = isRotatable;
        this.registerStone();
    }

    private <T extends Block> DeferredBlock<T> createBlockWithItem(String blockID, Supplier<T> block) {
        return NSRegistryHelper.registerBlock(blockID, block);
    }

    public String getName() {
        return this.name;
    }

    private DeferredBlock<Block> createBasic(String name, Supplier<Block> template) {
        return this.createBlockWithItem(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)template.get())).destroyTime(this.hardness).mapColor(this.getMapColor())));
    }

    private DeferredBlock<RotatedPillarBlock> createRotatable(String name, Supplier<Block> template) {
        return this.createBlockWithItem(name, () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)template.get())).destroyTime(this.hardness).mapColor(this.getMapColor())));
    }

    private DeferredBlock<StairBlock> createStairs(String name, DeferredBlock<? extends Block> template) {
        return this.createBlockWithItem(name + "_stairs", () -> new StairBlock(((Block)template.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)template.get()))));
    }

    private DeferredBlock<SlabBlock> createSlab(String name, DeferredBlock<? extends Block> template) {
        return this.createBlockWithItem(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)template.get()))));
    }

    private DeferredBlock<WallBlock> createWall(String name, DeferredBlock<Block> template) {
        return this.createBlockWithItem(name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)template.get())).forceSolidOn()));
    }

    public boolean hasTiles() {
        return this.hasTiles;
    }

    public boolean hasCracked() {
        return this.hasCracked;
    }

    public boolean hasCobbled() {
        return this.hasCobbled;
    }

    public boolean hasMossy() {
        return this.hasMossy;
    }

    public boolean isRotatable() {
        return this.isRotatable;
    }

    public DeferredBlock<Block> getCobbled() {
        return this.cobbled;
    }

    public DeferredBlock<StairBlock> getCobbledStairs() {
        return this.cobbledStairs;
    }

    public DeferredBlock<SlabBlock> getCobbledSlab() {
        return this.cobbledSlab;
    }

    public DeferredBlock<WallBlock> getCobbledWall() {
        return this.cobbledWall;
    }

    public DeferredBlock<? extends Block> getBase() {
        return this.base;
    }

    public DeferredBlock<StairBlock> getBaseStairs() {
        return this.baseStairs;
    }

    public DeferredBlock<SlabBlock> getBaseSlab() {
        return this.baseSlab;
    }

    public DeferredBlock<Block> getPolished() {
        return this.polished;
    }

    public DeferredBlock<StairBlock> getPolishedStairs() {
        return this.polishedStairs;
    }

    public DeferredBlock<SlabBlock> getPolishedSlab() {
        return this.polishedSlab;
    }

    public DeferredBlock<WallBlock> getPolishedWall() {
        return this.polishedWall;
    }

    public DeferredBlock<Block> getTiles() {
        return this.tiles;
    }

    public DeferredBlock<StairBlock> getTilesStairs() {
        return this.tilesStairs;
    }

    public DeferredBlock<SlabBlock> getTilesSlab() {
        return this.tilesSlab;
    }

    public DeferredBlock<WallBlock> getTilesWall() {
        return this.tilesWall;
    }

    public DeferredBlock<Block> getBricks() {
        return this.bricks;
    }

    public DeferredBlock<StairBlock> getBricksStairs() {
        return this.bricksStairs;
    }

    public DeferredBlock<SlabBlock> getBricksSlab() {
        return this.bricksSlab;
    }

    public DeferredBlock<WallBlock> getBricksWall() {
        return this.bricksWall;
    }

    public DeferredBlock<Block> getChiseled() {
        return this.chiseled;
    }

    public DeferredBlock<Block> getCrackedBricks() {
        return this.crackedBricks;
    }

    public DeferredBlock<Block> getCrackedTiles() {
        return this.crackedTiles;
    }

    public DeferredBlock<Block> getMossyBricks() {
        return this.mossyBricks;
    }

    public DeferredBlock<StairBlock> getMossyBricksStairs() {
        return this.mossyBricksStairs;
    }

    public DeferredBlock<SlabBlock> getMossyBricksSlab() {
        return this.mossyBricksSlab;
    }

    public DeferredBlock<WallBlock> getMossyBricksWall() {
        return this.mossyBricksWall;
    }

    public DeferredBlock<Block> getMossyCobbled() {
        return this.mossyCobbled;
    }

    public DeferredBlock<StairBlock> getMossyCobbledStairs() {
        return this.mossyCobbledStairs;
    }

    public DeferredBlock<SlabBlock> getMossyCobbledSlab() {
        return this.mossyCobbledSlab;
    }

    public DeferredBlock<WallBlock> getMossyCobbledWall() {
        return this.mossyCobbledWall;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }
}

