/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import net.hibiscus.naturespirit.blocks.LargeFlowerBlock;
import net.hibiscus.naturespirit.blocks.MidFlowerBlock;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;

public class FlowerSet {
    private final String name;
    private final Item dyeColor;
    private final Holder<MobEffect> statusEffect;
    private final FlowerPreset preset;
    private DeferredBlock<?> flowerBlock;
    private DeferredBlock<FlowerPotBlock> pottedFlowerBlock;

    public FlowerSet(String name, Item dyeColor, Holder<MobEffect> statusEffect, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = statusEffect;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, Item dyeColor, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = null;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, Holder<MobEffect> statusEffect, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = statusEffect;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = null;
        this.preset = preset;
        this.registerFlower();
    }

    private void registerFlower() {
        if (this.isTall()) {
            this.flowerBlock = NSRegistryHelper.registerTallPlantBlock(this.name, () -> new TallFlowerBlock(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).ignitedByLava().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
        } else if (this.preset == FlowerPreset.BIG_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, () -> new LargeFlowerBlock(this.statusEffect, 7, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
        } else if (this.preset == FlowerPreset.SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, () -> new FlowerBlock(this.statusEffect, 7.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
        } else if (this.preset == FlowerPreset.MID_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, () -> new MidFlowerBlock(this.statusEffect, 7, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
        }
        if (this.hasFlowerPot()) {
            this.pottedFlowerBlock = NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + this.name, () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, this.flowerBlock, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
        }
    }

    public int getDyeNumber() {
        switch (this.preset.ordinal()) {
            case 2: 
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    public FlowerPreset getPreset() {
        return this.preset;
    }

    public boolean hasFlowerPot() {
        return this.getPreset() == FlowerPreset.SMALL || this.getPreset() == FlowerPreset.BIG_SMALL || this.getPreset() == FlowerPreset.MID_SMALL;
    }

    public boolean isTall() {
        return this.getPreset() == FlowerPreset.TALL || this.getPreset() == FlowerPreset.BIG_TALL;
    }

    public Item getDyeColor() {
        return this.dyeColor;
    }

    public DeferredBlock<?> getFlowerBlock() {
        return this.flowerBlock;
    }

    public DeferredBlock<?> getPottedFlowerBlock() {
        return this.pottedFlowerBlock;
    }

    public String getName() {
        return this.name;
    }

    public static enum FlowerPreset {
        SMALL,
        MID_SMALL,
        TALL,
        BIG_SMALL,
        BIG_TALL;

    }
}

