/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.mixin;

import java.util.Optional;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={CoralBlock.class})
public abstract class CoralBlockBlockMixin
extends Block {
    public CoralBlockBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Unique
    private static Optional<BlockPos> naturespirit$findColumnEnd(BlockGetter world, BlockPos pos) {
        BlockState blockState;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int i = 0;
        do {
            mutable.move(Direction.DOWN);
        } while ((blockState = world.getBlockState((BlockPos)mutable)).is(BlockTags.CORAL_BLOCKS) && ++i < 10);
        return blockState.is(Blocks.BUBBLE_COLUMN) ? Optional.of(mutable) : Optional.empty();
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (NSConfig.calciteGenerator && CoralBlockBlockMixin.naturespirit$findColumnEnd((BlockGetter)world, pos).isPresent()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (random.nextInt(25) != 0) continue;
                if (world.getBlockState(pos.relative(direction, 1)).is(Blocks.WATER)) {
                    world.setBlock(pos.relative(direction, 1), (BlockState)((BlockState)((AmethystClusterBlock)NSBlocks.SMALL_CALCITE_BUD.get()).defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (world.getBlockState(pos.relative(direction, 1)).is((Block)NSBlocks.SMALL_CALCITE_BUD.get())) {
                    world.setBlock(pos.relative(direction, 1), (BlockState)((BlockState)((AmethystClusterBlock)NSBlocks.LARGE_CALCITE_BUD.get()).defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(pos.relative(direction, 1)).getFluidState().is((Fluid)Fluids.WATER))), 2);
                    continue;
                }
                if (!world.getBlockState(pos.relative(direction, 1)).is((Block)NSBlocks.LARGE_CALCITE_BUD.get())) continue;
                world.setBlock(pos.relative(direction, 1), (BlockState)((BlockState)((AmethystClusterBlock)NSBlocks.CALCITE_CLUSTER.get()).defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(pos.relative(direction, 1)).getFluidState().is((Fluid)Fluids.WATER))), 2);
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

