/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CoconutHalfItem
extends Item {
    private final Item LeftOverItem;

    public CoconutHalfItem(Item.Properties settings, Item item) {
        super(settings);
        this.LeftOverItem = item;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        super.finishUsingItem(stack, world, user);
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayerEntity, stack);
            serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!world.isClientSide) {
            user.removeAllEffects();
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)this.LeftOverItem);
        }
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            if (!playerEntity.getAbilities().instabuild) {
                ItemStack itemStack = new ItemStack((ItemLike)this.LeftOverItem);
                if (!playerEntity.getInventory().add(itemStack)) {
                    playerEntity.drop(itemStack, false);
                }
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }
}

