/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.entity;

import net.hibiscus.naturespirit.entity.NSBoatEntity;
import net.hibiscus.naturespirit.items.NSBoatItem;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class NSChestBoatEntity
extends ChestBoat {
    public NSChestBoatEntity(EntityType<? extends ChestBoat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public NSChestBoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this(NSEntityTypes.NS_CHEST_BOAT.get(), pLevel);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public Item getDropItem() {
        return switch (this.getNSVariant()) {
            case NSBoatEntity.Type.REDWOOD -> (NSBoatItem)((Object)NSBlocks.REDWOOD.getChestBoatItem().get());
            case NSBoatEntity.Type.SUGI -> (NSBoatItem)((Object)NSBlocks.SUGI.getChestBoatItem().get());
            case NSBoatEntity.Type.WISTERIA -> (NSBoatItem)((Object)NSBlocks.WISTERIA.getChestBoatItem().get());
            case NSBoatEntity.Type.FIR -> (NSBoatItem)((Object)NSBlocks.FIR.getChestBoatItem().get());
            case NSBoatEntity.Type.WILLOW -> (NSBoatItem)((Object)NSBlocks.WILLOW.getChestBoatItem().get());
            case NSBoatEntity.Type.ASPEN -> (NSBoatItem)((Object)NSBlocks.ASPEN.getChestBoatItem().get());
            case NSBoatEntity.Type.MAPLE -> (NSBoatItem)((Object)NSBlocks.MAPLE.getChestBoatItem().get());
            case NSBoatEntity.Type.CYPRESS -> (NSBoatItem)((Object)NSBlocks.CYPRESS.getChestBoatItem().get());
            case NSBoatEntity.Type.OLIVE -> (NSBoatItem)((Object)NSBlocks.OLIVE.getChestBoatItem().get());
            case NSBoatEntity.Type.JOSHUA -> (NSBoatItem)((Object)NSBlocks.JOSHUA.getChestBoatItem().get());
            case NSBoatEntity.Type.GHAF -> (NSBoatItem)((Object)NSBlocks.GHAF.getChestBoatItem().get());
            case NSBoatEntity.Type.PALO_VERDE -> (NSBoatItem)((Object)NSBlocks.PALO_VERDE.getChestBoatItem().get());
            case NSBoatEntity.Type.COCONUT -> (NSBoatItem)((Object)NSBlocks.COCONUT.getChestBoatItem().get());
            case NSBoatEntity.Type.CEDAR -> (NSBoatItem)((Object)NSBlocks.CEDAR.getChestBoatItem().get());
            case NSBoatEntity.Type.LARCH -> (NSBoatItem)((Object)NSBlocks.LARCH.getChestBoatItem().get());
            case NSBoatEntity.Type.MAHOGANY -> (NSBoatItem)((Object)NSBlocks.MAHOGANY.getChestBoatItem().get());
            case NSBoatEntity.Type.SAXAUL -> (NSBoatItem)((Object)NSBlocks.SAXAUL.getChestBoatItem().get());
            default -> super.getDropItem();
        };
    }

    public void setVariant(NSBoatEntity.Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326198_) {
        p_326198_.define(DATA_ID_TYPE, (Object)NSBoatEntity.Type.REDWOOD.ordinal());
        p_326198_.define(DATA_ID_PADDLE_LEFT, (Object)false);
        p_326198_.define(DATA_ID_PADDLE_RIGHT, (Object)false);
        p_326198_.define(DATA_ID_BUBBLE_TIME, (Object)0);
        p_326198_.define(DATA_ID_HURT, (Object)0);
        p_326198_.define(DATA_ID_HURTDIR, (Object)1);
        p_326198_.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("Type", this.getNSVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Type", 8)) {
            this.setVariant(NSBoatEntity.Type.byName(pCompound.getString("Type")));
        }
    }

    public NSBoatEntity.Type getNSVariant() {
        return NSBoatEntity.Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }
}

