/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.entity;

import java.util.function.IntFunction;
import net.hibiscus.naturespirit.items.NSBoatItem;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class NSBoatEntity
extends Boat {
    public NSBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public NSBoatEntity(Level level, double pX, double pY, double pZ) {
        this(NSEntityTypes.NS_BOAT.get(), level);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public Item getDropItem() {
        return switch (this.getNSVariant().ordinal()) {
            case 0 -> (NSBoatItem)((Object)NSBlocks.REDWOOD.getBoatItem().get());
            case 1 -> (NSBoatItem)((Object)NSBlocks.SUGI.getBoatItem().get());
            case 2 -> (NSBoatItem)((Object)NSBlocks.WISTERIA.getBoatItem().get());
            case 3 -> (NSBoatItem)((Object)NSBlocks.FIR.getBoatItem().get());
            case 4 -> (NSBoatItem)((Object)NSBlocks.WILLOW.getBoatItem().get());
            case 5 -> (NSBoatItem)((Object)NSBlocks.ASPEN.getBoatItem().get());
            case 6 -> (NSBoatItem)((Object)NSBlocks.MAPLE.getBoatItem().get());
            case 7 -> (NSBoatItem)((Object)NSBlocks.CYPRESS.getBoatItem().get());
            case 8 -> (NSBoatItem)((Object)NSBlocks.OLIVE.getBoatItem().get());
            case 9 -> (NSBoatItem)((Object)NSBlocks.JOSHUA.getBoatItem().get());
            case 10 -> (NSBoatItem)((Object)NSBlocks.GHAF.getBoatItem().get());
            case 11 -> (NSBoatItem)((Object)NSBlocks.PALO_VERDE.getBoatItem().get());
            case 12 -> (NSBoatItem)((Object)NSBlocks.COCONUT.getBoatItem().get());
            case 13 -> (NSBoatItem)((Object)NSBlocks.CEDAR.getBoatItem().get());
            case 14 -> (NSBoatItem)((Object)NSBlocks.LARCH.getBoatItem().get());
            case 15 -> (NSBoatItem)((Object)NSBlocks.MAHOGANY.getBoatItem().get());
            case 16 -> (NSBoatItem)((Object)NSBlocks.SAXAUL.getBoatItem().get());
            default -> super.getDropItem();
        };
    }

    public void setVariant(Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getNSVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326198_) {
        p_326198_.define(DATA_ID_TYPE, (Object)Type.REDWOOD.ordinal());
        p_326198_.define(DATA_ID_PADDLE_LEFT, (Object)false);
        p_326198_.define(DATA_ID_PADDLE_RIGHT, (Object)false);
        p_326198_.define(DATA_ID_BUBBLE_TIME, (Object)0);
        p_326198_.define(DATA_ID_HURT, (Object)0);
        p_326198_.define(DATA_ID_HURTDIR, (Object)1);
        p_326198_.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("Type", this.getNSVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Type", 8)) {
            this.setVariant(Type.byName(pCompound.getString("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        REDWOOD((Block)NSBlocks.REDWOOD.getPlanks().get(), "redwood"),
        SUGI((Block)NSBlocks.SUGI.getPlanks().get(), "sugi"),
        WISTERIA((Block)NSBlocks.WISTERIA.getPlanks().get(), "wisteria"),
        FIR((Block)NSBlocks.FIR.getPlanks().get(), "fir"),
        WILLOW((Block)NSBlocks.WILLOW.getPlanks().get(), "willow"),
        ASPEN((Block)NSBlocks.ASPEN.getPlanks().get(), "aspen"),
        MAPLE((Block)NSBlocks.MAPLE.getPlanks().get(), "maple"),
        CYPRESS((Block)NSBlocks.CYPRESS.getPlanks().get(), "cypress"),
        OLIVE((Block)NSBlocks.OLIVE.getPlanks().get(), "olive"),
        JOSHUA((Block)NSBlocks.JOSHUA.getPlanks().get(), "joshua"),
        GHAF((Block)NSBlocks.GHAF.getPlanks().get(), "ghaf"),
        PALO_VERDE((Block)NSBlocks.PALO_VERDE.getPlanks().get(), "palo_verde"),
        COCONUT((Block)NSBlocks.COCONUT.getPlanks().get(), "coconut"),
        CEDAR((Block)NSBlocks.CEDAR.getPlanks().get(), "cedar"),
        LARCH((Block)NSBlocks.LARCH.getPlanks().get(), "larch"),
        MAHOGANY((Block)NSBlocks.MAHOGANY.getPlanks().get(), "mahogany"),
        SAXAUL((Block)NSBlocks.SAXAUL.getPlanks().get(), "saxaul");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.byName(pName, (Enum)REDWOOD);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

