/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hibiscus.naturespirit.blocks.PizzaBlock;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaBlockEntity;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaToppingVariant;
import net.hibiscus.naturespirit.client.NSClient;
import net.hibiscus.naturespirit.client.render.PizzaToppingModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PizzaBlockEntityRenderer
implements BlockEntityRenderer<PizzaBlockEntity> {
    private final PizzaToppingModel pizzaToppingModel;

    public PizzaBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.pizzaToppingModel = new PizzaToppingModel(ctx.bakeLayer(NSClient.PIZZA_TOPPING));
    }

    public void render(PizzaBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState cachedState = entity.getBlockState();
        if (cachedState.getBlock() instanceof PizzaBlock) {
            int shape = (Integer)cachedState.getValue((Property)PizzaBlock.BITES);
            ModelPart model = switch (shape) {
                case 0 -> this.pizzaToppingModel.slice0;
                case 1 -> this.pizzaToppingModel.slice1;
                case 2 -> this.pizzaToppingModel.slice2;
                default -> this.pizzaToppingModel.slice3;
            };
            for (PizzaToppingVariant pizzaToppingVariant : entity.toppings) {
                VertexConsumer vertexConsumer = new Material(TextureAtlas.LOCATION_BLOCKS, pizzaToppingVariant.texturePath()).buffer(vertexConsumers, RenderType::entityCutout);
                model.render(matrices, vertexConsumer, light, overlay, -1);
            }
        }
    }
}

