/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.client;

import net.hibiscus.naturespirit.client.MapleLeavesParticle;
import net.hibiscus.naturespirit.client.render.CheeseArrowEntityRenderer;
import net.hibiscus.naturespirit.client.render.NSBoatRenderer;
import net.hibiscus.naturespirit.client.render.PizzaBlockEntityRenderer;
import net.hibiscus.naturespirit.client.render.PizzaToppingModel;
import net.hibiscus.naturespirit.entity.NSBoatEntity;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSEntityTypes;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

@EventBusSubscriber(modid="natures_spirit", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NSClient {
    public static final ModelLayerLocation PIZZA_TOPPING = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"natures_spirit", (String)"pizza"), "toppings");

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)(blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? blockPos.below() : blockPos)) : -1, new Block[]{(Block)NSBlocks.CATTAIL.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.SUGI.getLeaves().get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.MAHOGANY.getLeaves().get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.LARCH.getLeaves().get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.ASPEN.getLeaves().get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.LOTUS_STEM.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.LARGE_LUSH_FERN.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.LUSH_FERN.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.POTTED_LUSH_FERN.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : -1, new Block[]{(Block)NSBlocks.LOTUS_STEM.get()});
        event.register((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)new BlockPos(blockPos.getX(), -64, blockPos.getZ())) : -1, new Block[]{(Block)NSBlocks.LOTUS_FLOWER.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> FoliageColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.SUGI.getLeaves().get()});
        event.register((stack, tintIndex) -> FoliageColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.LARCH.getLeaves().get()});
        event.register((stack, tintIndex) -> FoliageColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.MAHOGANY.getLeaves().get()});
        event.register((stack, tintIndex) -> FoliageColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.ASPEN.getLeaves().get()});
        event.register((stack, tintIndex) -> GrassColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.LUSH_FERN.get()});
        event.register((stack, tintIndex) -> GrassColor.getDefaultColor(), new ItemLike[]{(ItemLike)NSBlocks.LARGE_LUSH_FERN.get()});
    }

    @SubscribeEvent
    public static void registerClient(FMLClientSetupEvent event) {
        Sheets.addWoodType((WoodType)NSBlocks.REDWOOD.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.SUGI.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.WISTERIA.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.FIR.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.WILLOW.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.ASPEN.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.MAPLE.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.CYPRESS.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.OLIVE.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.JOSHUA.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.GHAF.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.PALO_VERDE.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.COCONUT.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.CEDAR.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.LARCH.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.MAHOGANY.getWoodType().get());
        Sheets.addWoodType((WoodType)NSBlocks.SAXAUL.getWoodType().get());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.PIZZA_BLOCK.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.LARGE_CALCITE_BUD.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.SMALL_CALCITE_BUD.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.CALCITE_CLUSTER.get()), (RenderType)RenderType.cutout());
        for (DeferredBlock<?> block : NSRegistryHelper.RenderLayerHashMap.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.cutout());
        }
        for (DeferredBlock<?> block : NSRegistryHelper.LeavesHashMap.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.cutoutMipped());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.COCONUT_THATCH_CARPET.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.COCONUT_THATCH_SLAB.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.COCONUT_THATCH.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.COCONUT_THATCH_STAIRS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.EVERGREEN_THATCH_CARPET.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.EVERGREEN_THATCH_SLAB.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.EVERGREEN_THATCH.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.EVERGREEN_THATCH_STAIRS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.XERIC_THATCH_CARPET.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.XERIC_THATCH_SLAB.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.XERIC_THATCH.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NSBlocks.XERIC_THATCH_STAIRS.get()), (RenderType)RenderType.cutout());
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)NSParticleTypes.RED_MAPLE_LEAVES_PARTICLE.get(), spriteProvider -> (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new MapleLeavesParticle(world, x, y, z, spriteProvider));
        event.registerSpriteSet((ParticleType)NSParticleTypes.ORANGE_MAPLE_LEAVES_PARTICLE.get(), spriteProvider -> (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new MapleLeavesParticle(world, x, y, z, spriteProvider));
        event.registerSpriteSet((ParticleType)NSParticleTypes.YELLOW_MAPLE_LEAVES_PARTICLE.get(), spriteProvider -> (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new MapleLeavesParticle(world, x, y, z, spriteProvider));
        event.registerSpriteSet((ParticleType)NSParticleTypes.MILK_PARTICLE.get(), SuspendedTownParticle.ComposterFillProvider::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get(), PizzaBlockEntityRenderer::new);
        event.registerEntityRenderer(NSEntityTypes.CHEESE_ARROW.get(), CheeseArrowEntityRenderer::new);
        event.registerEntityRenderer(NSEntityTypes.NS_BOAT.get(), pContext -> new NSBoatRenderer(pContext, false));
        event.registerEntityRenderer(NSEntityTypes.NS_CHEST_BOAT.get(), pContext -> new NSBoatRenderer(pContext, true));
    }

    @SubscribeEvent
    public static void registerEntityRenderLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PIZZA_TOPPING, PizzaToppingModel::getTexturedModelData);
        for (NSBoatEntity.Type type : NSBoatEntity.Type.values()) {
            event.registerLayerDefinition(NSBoatRenderer.createBoatModelName(type), BoatModel::createBodyModel);
            event.registerLayerDefinition(NSBoatRenderer.createChestBoatModelName(type), ChestBoatModel::createBodyModel);
        }
    }
}

